/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class NetworkRestartTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkRestartTest.class);
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;
    protected ActiveMQQueue included = new ActiveMQQueue("include.test.foo");

    public void testConnectorRestart() throws Exception {
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer((Destination)this.included);
        MessageProducer localProducer = this.localSession.createProducer((Destination)this.included);
        localProducer.send((Message)this.localSession.createTextMessage("before"));
        Message before = remoteConsumer.receive(1000L);
        NetworkRestartTest.assertNotNull((Object)before);
        NetworkRestartTest.assertEquals((String)"before", (String)((TextMessage)before).getText());
        Thread.sleep(1000L);
        NetworkConnector connector = this.localBroker.getNetworkConnectorByName("networkConnector");
        LOG.info("Stopping connector");
        connector.stop();
        Thread.sleep(5000L);
        LOG.info("Starting connector");
        connector.start();
        Thread.sleep(5000L);
        localProducer.send((Message)this.localSession.createTextMessage("after"));
        Message after = remoteConsumer.receive(3000L);
        NetworkRestartTest.assertNotNull((Object)after);
        NetworkRestartTest.assertEquals((String)"after", (String)((TextMessage)after).getText());
    }

    public void testConnectorReAdd() throws Exception {
        MessageConsumer remoteConsumer = this.remoteSession.createConsumer((Destination)this.included);
        MessageProducer localProducer = this.localSession.createProducer((Destination)this.included);
        localProducer.send((Message)this.localSession.createTextMessage("before"));
        Message before = remoteConsumer.receive(1000L);
        NetworkRestartTest.assertNotNull((Object)before);
        NetworkRestartTest.assertEquals((String)"before", (String)((TextMessage)before).getText());
        Thread.sleep(1000L);
        NetworkConnector connector = this.localBroker.getNetworkConnectorByName("networkConnector");
        LOG.info("Removing connector");
        connector.stop();
        this.localBroker.removeNetworkConnector(connector);
        Thread.sleep(5000L);
        LOG.info("Re-adding connector");
        this.localBroker.addNetworkConnector(connector);
        connector.start();
        Thread.sleep(5000L);
        localProducer.send((Message)this.localSession.createTextMessage("after"));
        Message after = remoteConsumer.receive(3000L);
        NetworkRestartTest.assertNotNull((Object)after);
        NetworkRestartTest.assertEquals((String)"after", (String)((TextMessage)after).getText());
    }

    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
        this.doSetUp();
    }

    protected void tearDown() throws Exception {
        this.localBroker.deleteAllMessages();
        this.remoteBroker.deleteAllMessages();
        this.doTearDown();
        super.tearDown();
    }

    protected void doTearDown() throws Exception {
        this.localConnection.close();
        this.remoteConnection.close();
        this.localBroker.stop();
        this.localBroker.waitUntilStopped();
        this.remoteBroker.stop();
        this.remoteBroker.waitUntilStopped();
    }

    protected void doSetUp() throws Exception {
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.setDeleteAllMessagesOnStartup(true);
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
        this.localBroker = this.createLocalBroker();
        this.localBroker.setDeleteAllMessagesOnStartup(true);
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        String localURI = "tcp://localhost:61616";
        String remoteURI = "tcp://localhost:61617";
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(localURI);
        this.localConnection = fac.createConnection();
        this.localConnection.setClientID("local");
        this.localConnection.start();
        fac = new ActiveMQConnectionFactory(remoteURI);
        fac.setWatchTopicAdvisories(false);
        this.remoteConnection = fac.createConnection();
        this.remoteConnection.setClientID("remote");
        this.remoteConnection.start();
        this.localSession = this.localConnection.createSession(false, 1);
        this.remoteSession = this.remoteConnection.createSession(false, 1);
    }

    protected String getRemoteBrokerURI() {
        return "org/apache/activemq/network/remoteBroker.xml";
    }

    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker.xml";
    }

    protected BrokerService createBroker(String uri) throws Exception {
        ClassPathResource resource = new ClassPathResource(uri);
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        resource = new ClassPathResource(uri);
        factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService result = factory.getBroker();
        return result;
    }

    protected BrokerService createLocalBroker() throws Exception {
        return this.createBroker(this.getLocalBrokerURI());
    }

    protected BrokerService createRemoteBroker() throws Exception {
        return this.createBroker(this.getRemoteBrokerURI());
    }
}

