/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import jakarta.jms.Connection;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.plugin.StatisticsBrokerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStatisticsPluginTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerStatisticsPluginTest.class);
    private Connection connection;
    private BrokerService broker;

    public void testBrokerStats() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue query = session.createQueue("ActiveMQ.Statistics.Broker");
        MessageProducer producer = session.createProducer((jakarta.jms.Destination)query);
        Message msg = session.createMessage();
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send(msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testBrokerStatsReset() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        Queue query = session.createQueue("ActiveMQ.Statistics.Broker");
        MessageProducer producer = session.createProducer(null);
        producer.send((jakarta.jms.Destination)testQueue, session.createMessage());
        Message msg = session.createMessage();
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getLong("enqueueCount") >= 1L ? 1 : 0) != 0);
        msg = session.createMessage();
        msg.setBooleanProperty("ActiveMQ.Statistics.Broker.Reset", true);
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertEquals((long)0L, (long)reply.getLong("enqueueCount"));
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testDestinationStats() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Destination" + testQueue.getQueueName());
        Message msg = session.createMessage();
        producer.send((jakarta.jms.Destination)testQueue, msg);
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
        BrokerStatisticsPluginTest.assertTrue((reply.getLong("averageMessageSize") > 0L ? 1 : 0) != 0);
    }

    public void testDestinationStatsWithDot() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Destination." + testQueue.getQueueName());
        Message msg = session.createMessage();
        producer.send((jakarta.jms.Destination)testQueue, msg);
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testDestinationStatsWithNullTermination() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Destination." + testQueue.getQueueName());
        Message msg = session.createMessage();
        msg.setBooleanProperty("ActiveMQ.Statistics.Destination.List.End.With.Null", true);
        producer.send((jakarta.jms.Destination)testQueue, msg);
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertEquals((long)1L, (long)reply.getLong("size"));
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
        MapMessage nullReply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)nullReply);
        BrokerStatisticsPluginTest.assertFalse((boolean)nullReply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((nullReply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)nullReply.getJMSPriority());
    }

    public void testDestinationStatsWithFirstMessageTimestamp() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Destination." + testQueue.getQueueName());
        Message msg = session.createMessage();
        msg.setBooleanProperty("ActiveMQ.Statistics.Destination.Include.First.Message.Timestamp", true);
        producer.send((jakarta.jms.Destination)testQueue, msg);
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertEquals((long)1L, (long)reply.getLong("size"));
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertTrue((reply.getLong("firstMessageTimestamp") > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertTrue((System.currentTimeMillis() >= reply.getLong("firstMessageTimestamp") ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    public void testSubscriptionStats() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue replyTo = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((jakarta.jms.Destination)replyTo);
        Queue testQueue = session.createQueue("Test.Queue");
        MessageConsumer testConsumer = session.createConsumer((jakarta.jms.Destination)testQueue);
        MessageProducer producer = session.createProducer(null);
        Queue query = session.createQueue("ActiveMQ.Statistics.Subscription");
        Message msg = session.createMessage();
        producer.send((jakarta.jms.Destination)testQueue, msg);
        msg.setJMSReplyTo((jakarta.jms.Destination)replyTo);
        producer.send((jakarta.jms.Destination)query, msg);
        MapMessage reply = (MapMessage)consumer.receive(10000L);
        BrokerStatisticsPluginTest.assertNotNull((Object)reply);
        BrokerStatisticsPluginTest.assertTrue((boolean)reply.getMapNames().hasMoreElements());
        BrokerStatisticsPluginTest.assertTrue((reply.getJMSTimestamp() > 0L ? 1 : 0) != 0);
        BrokerStatisticsPluginTest.assertEquals((int)4, (int)reply.getJMSPriority());
    }

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory((String)this.broker.getTransportConnectorURIsAsMap().get("tcp"));
        this.connection = factory.createConnection();
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        BrokerPlugin[] plugins = new BrokerPlugin[]{new BrokerPluginSupport(){

            public Set<Destination> getDestinations(ActiveMQDestination destination) {
                return super.getDestinations(destination).stream().map(DestinationFilter::new).collect(Collectors.toSet());
            }
        }, new StatisticsBrokerPlugin()};
        answer.setPlugins(plugins);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector("tcp://localhost:0");
        answer.start();
        return answer;
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

