/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.LinkedList;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.SimpleCachedLDAPAuthorizationMap;
import org.apache.activemq.util.Wait;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCachedLDAPAuthorizationMapLegacyTest
extends AbstractLdapTestUnit {
    static final GroupPrincipal GUESTS = new GroupPrincipal("guests");
    static final GroupPrincipal USERS = new GroupPrincipal("users");
    static final GroupPrincipal ADMINS = new GroupPrincipal("admins");
    protected LdapConnection connection;
    protected SimpleCachedLDAPAuthorizationMap map;

    @Before
    public void setup() throws Exception {
        this.connection = this.getLdapConnection();
        this.map = this.createMap();
    }

    @After
    public void cleanup() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.map != null) {
            this.map.destroy();
        }
    }

    @Test
    public void testQuery() throws Exception {
        this.map.query();
        Set readACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(readACLs)), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
    }

    @Test
    public void testSynchronousUpdate() throws Exception {
        this.map.setRefreshInterval(1);
        this.map.query();
        Set readACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(readACLs)), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        LdifReader reader = new LdifReader(this.getRemoveLdif());
        for (LdifEntry entry : reader) {
            this.connection.delete(entry.getDn());
        }
        reader.close();
        Assert.assertTrue((String)"did not get expected size. ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AbstractCachedLDAPAuthorizationMapLegacyTest.this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO")).size() == 0;
            }
        }));
        Assert.assertNull((Object)this.map.getTempDestinationReadACLs());
        Assert.assertNull((Object)this.map.getTempDestinationWriteACLs());
        Assert.assertNull((Object)this.map.getTempDestinationAdminACLs());
    }

    @Test
    public void testWildcards() throws Exception {
        this.map.query();
        Set fooACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FOO.1"));
        Assert.assertEquals((String)("set size: " + String.valueOf(fooACLs)), (long)2L, (long)fooACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)fooACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)fooACLs.contains(USERS));
        Set barACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("BAR.2"));
        Assert.assertEquals((String)("set size: " + String.valueOf(barACLs)), (long)2L, (long)barACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)barACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)barACLs.contains(USERS));
    }

    @Test
    public void testAdvisory() throws Exception {
        this.map.query();
        Set readACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQTopic("ActiveMQ.Advisory.Connection"));
        Assert.assertEquals((String)("set size: " + String.valueOf(readACLs)), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    @Test
    public void testTemporary() throws Exception {
        this.map.query();
        Thread.sleep(1000L);
        Set readACLs = this.map.getTempDestinationReadACLs();
        Assert.assertEquals((String)("set size: " + String.valueOf(readACLs)), (long)2L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
    }

    @Test
    public void testAdd() throws Exception {
        this.map.query();
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        LdifReader reader = new LdifReader(this.getAddLdif());
        for (LdifEntry entry : reader) {
            this.connection.add(entry.getEntry());
        }
        reader.close();
        Thread.sleep(2000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
    }

    @Test
    public void testRemove() throws Exception {
        this.map.query();
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        LdifReader reader = new LdifReader(this.getRemoveLdif());
        for (LdifEntry entry : reader) {
            this.connection.delete(entry.getDn());
        }
        reader.close();
        Thread.sleep(2000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        Assert.assertTrue((this.map.getTempDestinationReadACLs() == null || this.map.getTempDestinationReadACLs().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getTempDestinationWriteACLs() == null || this.map.getTempDestinationWriteACLs().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((this.map.getTempDestinationAdminACLs() == null || this.map.getTempDestinationAdminACLs().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testRenameDestination() throws Exception {
        this.map.query();
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        this.connection.rename(new Dn(new String[]{"cn=TEST.FOO," + this.getQueueBaseDn()}), new Rdn("cn=TEST.BAR"));
        Thread.sleep(2000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.BAR"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
    }

    @Test
    public void testRenamePermission() throws Exception {
        this.map.query();
        this.connection.delete(new Dn(new String[]{"cn=Read,cn=TEST.FOO," + this.getQueueBaseDn()}));
        Thread.sleep(2000L);
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        failedACLs = this.map.getWriteACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        this.connection.rename(new Dn(new String[]{"cn=Write,cn=TEST.FOO," + this.getQueueBaseDn()}), new Rdn("cn=Read"));
        Thread.sleep(2000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        failedACLs = this.map.getWriteACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
    }

    @Test
    public void testChange() throws Exception {
        this.map.query();
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        Dn dn = new Dn(new String[]{"cn=read,cn=TEST.FOO," + this.getQueueBaseDn()});
        ModifyRequestImpl request = new ModifyRequestImpl();
        request.setName(dn);
        this.setupModifyRequest((ModifyRequest)request);
        this.connection.modify((ModifyRequest)request);
        Thread.sleep(2000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)1L, (long)failedACLs.size());
        request = new ModifyRequestImpl();
        request.setName(new Dn(new String[]{"cn=TEST.FOO," + this.getQueueBaseDn()}));
        request.add("description", new String[]{"This is a description!  In fact, it is a very good description."});
        this.connection.modify((ModifyRequest)request);
        Thread.sleep(2000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)1L, (long)failedACLs.size());
    }

    @Test
    public void testRestartAsync() throws Exception {
        this.testRestart(false);
    }

    @Test
    public void testRestartSync() throws Exception {
        this.testRestart(true);
    }

    public void testRestart(final boolean sync) throws Exception {
        if (sync) {
            this.map.setRefreshInterval(1000);
        }
        this.map.query();
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        AbstractCachedLDAPAuthorizationMapLegacyTest.getLdapServer().stop();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                if (sync) {
                    return !AbstractCachedLDAPAuthorizationMapLegacyTest.this.map.isContextAlive();
                }
                return AbstractCachedLDAPAuthorizationMapLegacyTest.this.map.context == null;
            }
        }, (long)300000L);
        failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOO"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)2L, (long)failedACLs.size());
        AbstractCachedLDAPAuthorizationMapLegacyTest.getLdapServer().start();
        Thread.sleep(2000L);
        this.connection = this.getLdapConnection();
        LdifReader reader = new LdifReader(this.getAddLdif());
        for (LdifEntry entry : reader) {
            this.connection.add(entry.getEntry());
        }
        reader.close();
        Assert.assertTrue((String)"did not get expected size. ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AbstractCachedLDAPAuthorizationMapLegacyTest.this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED")).size() == 2;
            }
        }, (long)300000L));
    }

    protected SimpleCachedLDAPAuthorizationMap createMap() {
        return new SimpleCachedLDAPAuthorizationMap();
    }

    protected abstract InputStream getAddLdif();

    protected abstract InputStream getRemoveLdif();

    protected void setupModifyRequest(ModifyRequest request) {
        request.remove("member", new String[]{"cn=users"});
    }

    protected abstract String getQueueBaseDn();

    protected abstract LdapConnection getLdapConnection() throws Exception;

    public static void cleanAndLoad(String deleteFromDn, String ldifResourcePath, String ldapHost, int ldapPort, String ldapUser, String ldapPass, DirContext context) throws Exception {
        block5: {
            LinkedList<String> dns = new LinkedList<String>();
            dns.add(deleteFromDn);
            while (!dns.isEmpty()) {
                String name = (String)dns.get(dns.size() - 1);
                Context currentContext = (Context)context.lookup(name);
                NamingEnumeration<NameClassPair> namingEnum = currentContext.list("");
                if (namingEnum.hasMore()) {
                    while (namingEnum.hasMore()) {
                        dns.add(namingEnum.next().getNameInNamespace());
                    }
                    continue;
                }
                context.unbind(name);
                dns.remove(dns.size() - 1);
            }
            SecurityManager securityManager = new SecurityManager(){

                @Override
                public void checkPermission(Permission permission) {
                    if (permission.getName().contains("exitVM")) {
                        throw new SecurityException("System.exit calls disabled for the moment.");
                    }
                }
            };
            System.setSecurityManager(securityManager);
            File file = new File(AbstractCachedLDAPAuthorizationMapLegacyTest.class.getClassLoader().getResource(ldifResourcePath).toURI());
            Class<?> clazz = Class.forName("LDAPModify");
            Method mainMethod = clazz.getMethod("main", String[].class);
            try {
                mainMethod.invoke(null, new Object[]{new String[]{"-v", "-h", ldapHost, "-p", String.valueOf(ldapPort), "-D", ldapUser, "-w", ldapPass, "-a", "-f", file.toString()}});
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof SecurityException) break block5;
                throw e;
            }
        }
        System.setSecurityManager(null);
    }
}

