/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.activemq.security.AbstractCachedLDAPAuthorizationMapLegacyTest;
import org.apache.activemq.security.SimpleCachedLDAPAuthorizationMap;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCachedLDAPAuthorizationModuleTest
extends AbstractCachedLDAPAuthorizationMapLegacyTest {
    static final UserPrincipal JDOE = new UserPrincipal("jdoe");

    @Override
    @Test
    public void testQuery() throws Exception {
        this.map.query();
        Set readACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("TEST.FOOBAR"));
        Assert.assertEquals((String)("set size: " + String.valueOf(readACLs)), (long)3L, (long)readACLs.size());
        Assert.assertTrue((String)"Contains admin group", (boolean)readACLs.contains(ADMINS));
        Assert.assertTrue((String)"Contains users group", (boolean)readACLs.contains(USERS));
        Assert.assertTrue((String)"Contains jdoe user", (boolean)readACLs.contains(JDOE));
        Set failedACLs = this.map.getReadACLs((ActiveMQDestination)new ActiveMQQueue("FAILED"));
        Assert.assertEquals((String)("set size: " + String.valueOf(failedACLs)), (long)0L, (long)failedACLs.size());
        super.testQuery();
    }

    @Override
    protected final void setupModifyRequest(ModifyRequest request) {
        request.remove("member", new String[]{this.getMemberAttributeValueForModifyRequest()});
    }

    protected abstract String getMemberAttributeValueForModifyRequest();

    @Override
    protected SimpleCachedLDAPAuthorizationMap createMap() {
        SimpleCachedLDAPAuthorizationMap map = super.createMap();
        map.setLegacyGroupMapping(false);
        return map;
    }
}

