/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import org.apache.activemq.spring.ConsumerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;

public class SpringConsumer
extends ConsumerBean
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(SpringConsumer.class);
    private JmsTemplate template;
    private String myId = "foo";
    private Destination destination;
    private Connection connection;
    private Session session;
    private MessageConsumer consumer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        String selector = "next = '" + this.myId + "'";
        try {
            ConnectionFactory factory = this.template.getConnectionFactory();
            Connection connection = this.connection = factory.createConnection();
            synchronized (connection) {
                if (this.connection.getClientID() == null) {
                    this.connection.setClientID(this.myId);
                }
            }
            this.connection.start();
            this.session = this.connection.createSession(true, 2);
            this.consumer = this.session.createConsumer(this.destination, selector, false);
            this.consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException ex) {
            LOG.error("", (Throwable)ex);
            throw ex;
        }
    }

    public void stop() throws JMSException {
        if (this.consumer != null) {
            this.consumer.close();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public void onMessage(Message message) {
        super.onMessage(message);
        try {
            message.acknowledge();
        }
        catch (JMSException e) {
            LOG.error("Failed to acknowledge: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getMyId() {
        return this.myId;
    }

    public void setMyId(String myId) {
        this.myId = myId;
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }
}

