/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.util.HashMap;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.SuppressReplyException;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.LeaseLockerIOExceptionHandler;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.Wait;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.States;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.StatePredicate;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class JDBCIOExceptionHandlerMockeryTest {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCIOExceptionHandlerMockeryTest.class);
    private HashMap<Thread, Throwable> exceptions = new HashMap();

    @Test
    public void testShutdownWithoutTransportRestart() throws Exception {
        Mockery context = new Mockery(){
            {
                this.setImposteriser(ClassImposteriser.INSTANCE);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("unexpected exception {} on thread {}", (Object)e, (Object)t);
                JDBCIOExceptionHandlerMockeryTest.this.exceptions.put(t, e);
            }
        });
        final BrokerService brokerService = (BrokerService)context.mock(BrokerService.class);
        final JDBCPersistenceAdapter jdbcPersistenceAdapter = (JDBCPersistenceAdapter)context.mock(JDBCPersistenceAdapter.class);
        final Locker locker = (Locker)context.mock(Locker.class);
        final States jdbcConn = context.states("jdbc").startsAs("down");
        final States broker = context.states("broker").startsAs("started");
        context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BrokerService)this.allowing(brokerService)).isStarted();
                this.will(3.returnValue((Object)true));
                ((BrokerService)this.allowing(brokerService)).isRestartAllowed();
                this.will(3.returnValue((Object)false));
                ((BrokerService)this.allowing(brokerService)).setSystemExitOnShutdown(this.with(false));
                ((BrokerService)this.allowing(brokerService)).stopAllConnectors((ServiceStopper)this.with(3.any(ServiceStopper.class)));
                ((BrokerService)this.allowing(brokerService)).getPersistenceAdapter();
                this.will(3.returnValue((Object)jdbcPersistenceAdapter));
                ((JDBCPersistenceAdapter)this.allowing(jdbcPersistenceAdapter)).allowIOResumption();
                ((JDBCPersistenceAdapter)this.allowing(jdbcPersistenceAdapter)).getLocker();
                this.will(3.returnValue((Object)locker));
                ((Locker)this.allowing(locker)).keepAlive();
                this.when((StatePredicate)jdbcConn.is("down"));
                this.will(3.returnValue((Object)true));
                ((Locker)this.allowing(locker)).keepAlive();
                this.when((StatePredicate)jdbcConn.is("up"));
                this.will(3.returnValue((Object)false));
                ((JDBCPersistenceAdapter)this.allowing(jdbcPersistenceAdapter)).checkpoint(this.with(true));
                this.then(jdbcConn.is("up"));
                ((BrokerService)this.allowing(brokerService)).stop();
                this.then(broker.is("stopped"));
            }
        });
        LeaseLockerIOExceptionHandler underTest = new LeaseLockerIOExceptionHandler();
        underTest.setBrokerService(brokerService);
        try {
            underTest.handle(new IOException());
            Assert.fail((String)"except suppress reply ex");
        }
        catch (SuppressReplyException suppressReplyException) {
            // empty catch block
        }
        Assert.assertTrue((String)"broker stopped state triggered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("broker state {}", (Object)broker);
                return broker.is("stopped").isActive();
            }
        }));
        context.assertIsSatisfied();
        Assert.assertTrue((String)("no exceptions: " + String.valueOf(this.exceptions)), (boolean)this.exceptions.isEmpty());
    }
}

