/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.Message;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.StoreOrderTest;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.ByteSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCStoreOrderTest
extends StoreOrderTest {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCStoreOrderTest.class);

    @Override
    protected void dumpMessages() throws Exception {
        OpenWireFormat wireFormat = new OpenWireFormat();
        Connection conn = ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).getDataSource().getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT ID, MSG FROM ACTIVEMQ_MSGS");
        ResultSet result = statement.executeQuery();
        while (result.next()) {
            long id = result.getLong(1);
            Message message = (Message)wireFormat.unmarshal(new ByteSequence(result.getBytes(2)));
            LOG.info("id: " + id + ", message SeqId: " + message.getMessageId().getBrokerSequenceId() + ", MSG: " + String.valueOf(message));
        }
        statement.close();
        conn.close();
    }

    @Override
    protected void setPersistentAdapter(BrokerService brokerService) throws Exception {
        brokerService.setPersistenceAdapter((PersistenceAdapter)new JDBCPersistenceAdapter());
    }
}

