/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.cursors.FilePendingMessageCursor;
import org.apache.activemq.broker.region.cursors.FilePendingMessageCursorTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.plist.PListImpl;
import org.apache.activemq.usage.SystemUsage;
import org.junit.Assert;
import org.junit.Test;

public class KahaDBFilePendingMessageCursorTest
extends FilePendingMessageCursorTestSupport {
    @Test
    public void testAddRemoveAddIndexSize() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(false);
        SystemUsage usage = this.brokerService.getSystemUsage();
        usage.getMemoryUsage().setLimit(153600L);
        String body = new String(new byte[1024]);
        Queue destination = new Queue(this.brokerService, (ActiveMQDestination)new ActiveMQQueue("Q"), null, new DestinationStatistics(), null);
        this.brokerService.start();
        this.underTest = new FilePendingMessageCursor(this.brokerService.getBroker(), "test", false);
        this.underTest.setSystemUsage(usage);
        LOG.info("start");
        PageFile pageFile = ((PListImpl)this.underTest.getDiskList()).getPageFile();
        LOG.info("page count: " + pageFile.getPageCount());
        LOG.info("free count: " + pageFile.getFreePageCount());
        LOG.info("content size: " + pageFile.getPageContentSize());
        long initialPageCount = pageFile.getPageCount();
        int numMessages = 1000;
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 1000; ++i) {
                ActiveMQMessage mqMessage = new ActiveMQMessage();
                mqMessage.setStringProperty("body", body);
                mqMessage.setMessageId(new MessageId("1:2:3:" + i));
                mqMessage.setMemoryUsage(usage.getMemoryUsage());
                mqMessage.setRegionDestination((Message.MessageDestination)destination);
                this.underTest.addMessageLast((MessageReference)new IndirectMessageReference((Message)mqMessage));
            }
            Assert.assertFalse((String)("cursor is not full " + String.valueOf(usage.getTempUsage())), (boolean)this.underTest.isFull());
            this.underTest.reset();
            long receivedCount = 0L;
            while (this.underTest.hasNext()) {
                MessageReference ref = this.underTest.next();
                this.underTest.remove();
                ref.decrementReferenceCount();
                Assert.assertEquals((String)"id is correct", (long)receivedCount++, (long)ref.getMessageId().getProducerSequenceId());
            }
            Assert.assertEquals((String)"got all messages back", (long)receivedCount, (long)1000L);
            LOG.info("page count: " + pageFile.getPageCount());
            LOG.info("free count: " + pageFile.getFreePageCount());
            LOG.info("content size: " + pageFile.getPageContentSize());
        }
        Assert.assertEquals((String)"expected page usage", (long)initialPageCount, (long)(pageFile.getPageCount() - pageFile.getFreePageCount()));
        LOG.info("Destroy");
        this.underTest.destroy();
        LOG.info("page count: " + pageFile.getPageCount());
        LOG.info("free count: " + pageFile.getFreePageCount());
        LOG.info("content size: " + pageFile.getPageContentSize());
        Assert.assertEquals((String)"expected page usage", (long)(initialPageCount - 1L), (long)(pageFile.getPageCount() - pageFile.getFreePageCount()));
    }
}

