/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.test.JmsSendReceiveTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTopicSendReceiveWithTwoConnectionsTest
extends JmsSendReceiveTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsTopicSendReceiveWithTwoConnectionsTest.class);
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        LOG.info("Creating send connection");
        this.sendConnection = this.createSendConnection();
        LOG.info("Starting send connection");
        this.sendConnection.start();
        LOG.info("Creating receive connection");
        this.receiveConnection = this.createReceiveConnection();
        LOG.info("Starting receive connection");
        this.receiveConnection.start();
        LOG.info("Created sendConnection: " + String.valueOf(this.sendConnection));
        LOG.info("Created receiveConnection: " + String.valueOf(this.receiveConnection));
        this.session = this.sendConnection.createSession(false, 1);
        this.receiveSession = this.receiveConnection.createSession(false, 1);
        LOG.info("Created sendSession: " + String.valueOf(this.session));
        LOG.info("Created receiveSession: " + String.valueOf(this.receiveSession));
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        LOG.info("Created producer: " + String.valueOf(this.producer) + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        LOG.info("Created  consumer destination: " + String.valueOf(this.consumerDestination) + " of type: " + String.valueOf(this.consumerDestination.getClass()));
        LOG.info("Created  producer destination: " + String.valueOf(this.producerDestination) + " of type: " + String.valueOf(this.producerDestination.getClass()));
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener((MessageListener)this);
        LOG.info("Started connections");
    }

    protected MessageConsumer createConsumer() throws JMSException {
        return this.receiveSession.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }

    protected Connection createReceiveConnection() throws Exception {
        return this.createConnection();
    }

    protected Connection createSendConnection() throws Exception {
        return this.createConnection();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }
}

