/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BadConnectionTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BadConnectionTest.class);
    protected Transport transport;

    public void testConnectingToUnavailableServer() throws Exception {
        try {
            this.transport.asyncRequest((Object)new ActiveMQMessage(), null);
            BadConnectionTest.fail((String)"This should never succeed");
        }
        catch (IOException e) {
            LOG.info("Caught expected exception: " + String.valueOf(e), (Throwable)e);
        }
    }

    protected Transport createTransport() throws Exception {
        return TransportFactory.connect((URI)new URI("failover://(tcp://doesNotExist:1234)?useExponentialBackOff=false&maxReconnectAttempts=3&initialReconnectDelay=100"));
    }

    protected void setUp() throws Exception {
        this.transport = this.createTransport();
        this.transport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.transport.start();
    }

    protected void tearDown() throws Exception {
        if (this.transport != null) {
            this.transport.stop();
        }
    }
}

