/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverPrefetchZeroTest {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverPrefetchZeroTest.class);
    private static final String QUEUE_NAME = "FailoverPrefetchZero";
    private static final String TRANSPORT_URI = "tcp://localhost:0";
    private String url;
    final int prefetch = 0;
    BrokerService broker;

    @After
    public void stopBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void startBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = this.createBroker(deleteAllMessagesOnStartup);
        this.broker.start();
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        return this.createBroker(deleteAllMessagesOnStartup, TRANSPORT_URI);
    }

    public BrokerService createBroker(boolean deleteAllMessagesOnStartup, String bindAddress) throws Exception {
        this.broker = new BrokerService();
        this.broker.addConnector(bindAddress);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        this.url = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString();
        return this.broker;
    }

    @Test
    public void testPrefetchZeroConsumerThroughRestart() throws Exception {
        this.broker = this.createBroker(true);
        final CountDownLatch pullDone = new CountDownLatch(1);
        this.broker.setPlugins(new BrokerPlugin[]{new BrokerPluginSupport(){

            public Response messagePull(ConnectionContext context, final MessagePull pull) throws Exception {
                context.setDontSendReponse(true);
                pullDone.countDown();
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        LOG.info("Stopping broker on pull: " + String.valueOf(pull));
                        try {
                            FailoverPrefetchZeroTest.this.broker.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                return null;
            }
        }});
        this.broker.start();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + this.url + ")");
        cf.setWatchTopicAdvisories(false);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        Session consumerSession = connection.createSession(false, 1);
        Queue destination = consumerSession.createQueue("FailoverPrefetchZero?consumer.prefetchSize=0");
        final MessageConsumer consumer = consumerSession.createConsumer((Destination)destination);
        this.produceMessage(consumerSession, destination, 1L);
        final CountDownLatch receiveDone = new CountDownLatch(1);
        final Vector received = new Vector();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("receive one...");
                    Message msg = consumer.receive(30000L);
                    if (msg != null) {
                        received.add(msg);
                    }
                    receiveDone.countDown();
                    LOG.info("done receive");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Assert.assertTrue((String)"pull completed on broker", (boolean)pullDone.await(30L, TimeUnit.SECONDS));
        this.broker.waitUntilStopped();
        this.broker = this.createBroker(false, this.url);
        this.broker.start();
        Assert.assertTrue((String)"receive completed through failover", (boolean)receiveDone.await(30L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"we got our message:", (!received.isEmpty() ? 1 : 0) != 0);
        connection.close();
    }

    private void produceMessage(Session producerSession, Queue destination, long count) throws JMSException {
        MessageProducer producer = producerSession.createProducer((Destination)destination);
        int i = 0;
        while ((long)i < count) {
            TextMessage message = producerSession.createTextMessage("Test message " + i);
            producer.send((Message)message);
            ++i;
        }
        producer.close();
    }
}

