/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;

public class FailoverRandomTest
extends TestCase {
    BrokerService brokerA;
    BrokerService brokerB;

    public void setUp() throws Exception {
        this.brokerA = this.createBroker("A");
        this.brokerB = this.createBroker("B");
    }

    public void tearDown() throws Exception {
        this.brokerA.stop();
        this.brokerB.stop();
    }

    protected String getBrokerUrl() {
        return "tcp://localhost:0";
    }

    private BrokerService createBroker(String name) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("Broker" + name);
        broker.addConnector(this.getBrokerUrl());
        broker.getManagementContext().setCreateConnector(false);
        broker.setPersistent(false);
        broker.setUseJmx(false);
        broker.start();
        return broker;
    }

    public void testRandomConnections() throws Exception {
        String failoverUrl = "failover:(" + String.valueOf(((TransportConnector)this.brokerA.getTransportConnectors().get(0)).getConnectUri()) + "," + String.valueOf(((TransportConnector)this.brokerB.getTransportConnectors().get(0)).getConnectUri()) + ")";
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(failoverUrl);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        String brokerName1 = connection.getBrokerName();
        FailoverRandomTest.assertNotNull((Object)brokerName1);
        connection.close();
        String brokerName2 = brokerName1;
        int attempts = 40;
        while (brokerName1.equals(brokerName2) && attempts-- > 0) {
            connection = (ActiveMQConnection)cf.createConnection();
            connection.start();
            brokerName2 = connection.getBrokerName();
            FailoverRandomTest.assertNotNull((Object)brokerName2);
            connection.close();
        }
        FailoverRandomTest.assertTrue((String)(brokerName1 + "!=" + brokerName2), (!brokerName1.equals(brokerName2) ? 1 : 0) != 0);
    }
}

