/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.TransportListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitalReconnectDelayTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(InitalReconnectDelayTest.class);
    protected BrokerService broker1;
    protected BrokerService broker2;

    @Test
    public void testInitialReconnectDelay() throws Exception {
        String uriString = "failover://(tcp://localhost:" + ((TransportConnector)this.broker1.getTransportConnectors().get(0)).getConnectUri().getPort() + ",tcp://localhost:" + ((TransportConnector)this.broker2.getTransportConnectors().get(0)).getConnectUri().getPort() + ")?randomize=false&initialReconnectDelay=15000";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(uriString);
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("foo");
        MessageProducer producer = session.createProducer((Destination)destination);
        long start = new Date().getTime();
        producer.send((Message)session.createTextMessage("TEST"));
        long end = new Date().getTime();
        Assert.assertTrue((end - start < 2000L ? 1 : 0) != 0);
        LOG.info("Stopping the Broker1...");
        start = new Date().getTime();
        this.broker1.stop();
        LOG.info("Attempting to send... failover should kick in...");
        producer.send((Message)session.createTextMessage("TEST"));
        end = new Date().getTime();
        LOG.info("Failover took " + (end - start) + " ms.");
        Assert.assertTrue((String)("Failover took " + (end - start) + " ms and should be > 14000."), (end - start > 14000L ? 1 : 0) != 0);
    }

    @Test
    public void testNoSuspendedCallbackOnNoReconnect() throws Exception {
        String uriString = "failover://(tcp://localhost:" + ((TransportConnector)this.broker1.getTransportConnectors().get(0)).getConnectUri().getPort() + ",tcp://localhost:" + ((TransportConnector)this.broker2.getTransportConnectors().get(0)).getConnectUri().getPort() + ")?randomize=false&maxReconnectAttempts=0";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(uriString);
        final AtomicInteger calls = new AtomicInteger(0);
        connectionFactory.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
                LOG.info("on exception: " + String.valueOf(error));
                calls.set(1 | calls.intValue());
            }

            public void transportInterupted() {
                LOG.info("on transportInterupted");
                calls.set(2 | calls.intValue());
            }

            public void transportResumed() {
                LOG.info("on transportResumed");
                calls.set(4 | calls.intValue());
            }
        });
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue("foo");
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage message = session.createTextMessage("TEST");
        producer.send((Message)message);
        calls.set(0);
        LOG.info("Stopping the Broker1...");
        this.broker1.stop();
        LOG.info("Attempting to send... failover should throw on disconnect");
        try {
            producer.send((Destination)destination, (Message)message);
            Assert.fail((String)"Expect IOException to bubble up on send");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Only an exception is reported to the listener", (long)1L, (long)calls.get());
    }

    @Before
    public void setUp() throws Exception {
        String dataDir = "target/data/shared";
        this.broker1 = new BrokerService();
        this.broker1.setBrokerName("broker1");
        this.broker1.setDeleteAllMessagesOnStartup(true);
        this.broker1.setDataDirectory("target/data/shared");
        this.broker1.addConnector("tcp://localhost:0");
        this.broker1.setUseJmx(false);
        this.broker1.start();
        this.broker1.waitUntilStarted();
        this.broker2 = new BrokerService();
        this.broker2.setBrokerName("broker2");
        this.broker2.setDataDirectory("target/data/shared");
        this.broker2.setUseJmx(false);
        this.broker2.addConnector("tcp://localhost:0");
        this.broker2.start();
        this.broker2.waitUntilStarted();
    }

    protected String getSlaveXml() {
        return "org/apache/activemq/broker/ft/sharedFileSlave.xml";
    }

    protected String getMasterXml() {
        return "org/apache/activemq/broker/ft/sharedFileMaster.xml";
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker1.isStarted()) {
            this.broker1.stop();
            this.broker1.waitUntilStopped();
        }
        if (this.broker2.isStarted()) {
            this.broker2.stop();
            this.broker2.waitUntilStopped();
        }
    }
}

