/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.fanout;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.NetworkTestSupport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.mock.MockTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanoutTransportBrokerTest
extends NetworkTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FanoutTransportBrokerTest.class);
    public ActiveMQDestination destination;
    public int deliveryMode;

    public static Test suite() {
        return FanoutTransportBrokerTest.suite(FanoutTransportBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FanoutTransportBrokerTest.suite());
    }

    public void initCombosForTestPublisherFansout() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQTopic("TEST"), new ActiveMQQueue("TEST")});
    }

    public void testPublisherFansout() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        LOG.info("Starting the fanout connection.");
        StubConnection connection3 = this.createFanoutConnection();
        ConnectionInfo connectionInfo3 = this.createConnectionInfo();
        SessionInfo sessionInfo3 = this.createSessionInfo(connectionInfo3);
        ProducerInfo producerInfo3 = this.createProducerInfo(sessionInfo3);
        connection3.send((Command)connectionInfo3);
        connection3.send((Command)sessionInfo3);
        connection3.send((Command)producerInfo3);
        connection3.request((Command)this.createMessage(producerInfo3, this.destination, this.deliveryMode));
        FanoutTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connection1));
        this.assertNoMessagesLeft(connection1);
        FanoutTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connection2));
        this.assertNoMessagesLeft(connection2);
    }

    public void initCombosForTestPublisherWaitsForServerToBeUp() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQTopic("TEST")});
    }

    public void testPublisherWaitsForServerToBeUp() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        LOG.info("Starting the fanout connection.");
        final StubConnection connection3 = this.createFanoutConnection();
        ConnectionInfo connectionInfo3 = this.createConnectionInfo();
        SessionInfo sessionInfo3 = this.createSessionInfo(connectionInfo3);
        final ProducerInfo producerInfo3 = this.createProducerInfo(sessionInfo3);
        connection3.send((Command)connectionInfo3);
        connection3.send((Command)sessionInfo3);
        connection3.send((Command)producerInfo3);
        connection3.request((Command)this.createMessage(producerInfo3, this.destination, this.deliveryMode));
        FanoutTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connection1));
        this.assertNoMessagesLeft(connection1);
        FanoutTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connection2));
        this.assertNoMessagesLeft(connection2);
        final CountDownLatch publishDone = new CountDownLatch(1);
        MockTransport mt = (MockTransport)connection3.getTransport().narrow(MockTransport.class);
        mt.install(new TransportFilter(mt.getNext()){

            public void oneway(Object command) throws IOException {
                LOG.info("Dropping: " + String.valueOf(command));
            }
        });
        new Thread(){

            @Override
            public void run() {
                try {
                    connection3.request((Command)FanoutTransportBrokerTest.this.createMessage(producerInfo3, FanoutTransportBrokerTest.this.destination, FanoutTransportBrokerTest.this.deliveryMode));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                publishDone.countDown();
            }
        }.start();
        FanoutTransportBrokerTest.assertFalse((boolean)publishDone.await(3L, TimeUnit.SECONDS));
        LOG.info("Restarting Broker");
        this.restartRemoteBroker();
        LOG.info("Broker Restarted");
        FanoutTransportBrokerTest.assertTrue((boolean)publishDone.await(20L, TimeUnit.SECONDS));
    }

    @Override
    protected String getLocalURI() {
        return "tcp://localhost:61616";
    }

    @Override
    protected String getRemoteURI() {
        return "tcp://localhost:61617";
    }

    protected StubConnection createFanoutConnection() throws Exception {
        URI fanoutURI = new URI("fanout://(static://(" + String.valueOf(this.connector.getServer().getConnectURI()) + ",mock://" + String.valueOf(this.remoteConnector.getServer().getConnectURI()) + "))?fanOutQueues=true");
        Transport transport = TransportFactory.connect((URI)fanoutURI);
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }
}

