/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslBrokerService;
import org.apache.activemq.broker.SslContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.TransportBrokerTestSupport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslBrokerServiceTest
extends TransportBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SslBrokerServiceTest.class);
    TransportConnector needClientAuthConnector;
    TransportConnector limitedCipherSuites;

    @Override
    protected String getBindLocation() {
        return "ssl://localhost:0";
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        SslBrokerService service = new SslBrokerService();
        service.setPersistent(false);
        KeyManager[] km = SslBrokerServiceTest.getKeyManager();
        TrustManager[] tm = SslBrokerServiceTest.getTrustManager();
        this.connector = service.addSslConnector(this.getBindLocation(), km, tm, null);
        this.limitedCipherSuites = service.addSslConnector("ssl://localhost:0?transport.enabledCipherSuites=TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", km, tm, null);
        this.needClientAuthConnector = service.addSslConnector("ssl://localhost:0?transport.needClientAuth=true", km, tm, null);
        SslTransportFactory sslFactory = new SslTransportFactory();
        SslContext ctx = new SslContext(km, tm, null);
        SslContext.setCurrentSslContext((SslContext)ctx);
        TransportFactory.registerTransportFactory((String)"ssl", (TransportFactory)sslFactory);
        return service;
    }

    public void testNeedClientAuthReject() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, SslBrokerServiceTest.getTrustManager(), null);
        try {
            this.makeSSLConnection(context, null, this.needClientAuthConnector);
            SslBrokerServiceTest.fail((String)"expected failure on no client cert");
        }
        catch (SSLException expected) {
            expected.printStackTrace();
        }
        this.makeSSLConnection(context, null, this.connector);
    }

    public void testNeedClientAuthSucceed() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(SslBrokerServiceTest.getKeyManager(), SslBrokerServiceTest.getTrustManager(), null);
        this.makeSSLConnection(context, null, this.needClientAuthConnector);
    }

    public void testCipherSuitesDisabled() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(SslBrokerServiceTest.getKeyManager(), SslBrokerServiceTest.getTrustManager(), null);
        try {
            this.makeSSLConnection(context, new String[]{"SSL_RSA_WITH_RC4_128_MD5"}, this.limitedCipherSuites);
            SslBrokerServiceTest.fail((String)"expected failure on non allowed cipher suite");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
        this.makeSSLConnection(context, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}, this.limitedCipherSuites);
    }

    private void makeSSLConnection(SSLContext context, String[] enabledSuites, TransportConnector connector) throws Exception, UnknownHostException, SocketException {
        SSLSocket sslSocket = (SSLSocket)context.getSocketFactory().createSocket("localhost", connector.getUri().getPort());
        if (enabledSuites != null) {
            sslSocket.setEnabledCipherSuites(enabledSuites);
        }
        sslSocket.setSoTimeout(5000);
        SSLSession session = sslSocket.getSession();
        sslSocket.startHandshake();
        LOG.info("cyphersuite: " + session.getCipherSuite());
        LOG.info("peer port: " + session.getPeerPort());
        LOG.info("peer cert: " + session.getPeerCertificateChain()[0].toString());
    }

    public static TrustManager[] getTrustManager() throws Exception {
        TrustManager[] trustStoreManagers = null;
        KeyStore trustedCertStore = KeyStore.getInstance("jks");
        trustedCertStore.load(new FileInputStream("src/test/resources/client.keystore"), null);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustedCertStore);
        trustStoreManagers = tmf.getTrustManagers();
        return trustStoreManagers;
    }

    public static KeyManager[] getKeyManager() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("jks");
        KeyManager[] keystoreManagers = null;
        byte[] sslCert = SslBrokerServiceTest.loadClientCredential("src/test/resources/server.keystore");
        if (sslCert != null && sslCert.length > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(sslCert);
            ks.load(bin, "password".toCharArray());
            kmf.init(ks, "password".toCharArray());
            keystoreManagers = kmf.getKeyManagers();
        }
        return keystoreManagers;
    }

    private static byte[] loadClientCredential(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in.read(buf);
        }
        in.close();
        return out.toByteArray();
    }

    @Override
    protected void setUp() throws Exception {
        this.maxWait = 10000;
        super.setUp();
    }

    public static Test suite() {
        return SslBrokerServiceTest.suite(SslBrokerServiceTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SslBrokerServiceTest.suite());
    }
}

