/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportUriTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TransportUriTest.class);
    private static final String DIFF_SERV = "&diffServ=";
    private static final String TOS = "&typeOfService=";
    protected Connection connection;
    public String prefix;
    public String postfix;

    public void initCombosForTestUriOptionsWork() {
        this.initSharedCombos();
    }

    public void testUriOptionsWork() throws Exception {
        String uri = this.prefix + this.bindAddress + this.postfix;
        LOG.info("Connecting via: " + uri);
        this.connection = new ActiveMQConnectionFactory(uri).createConnection();
        this.connection.start();
    }

    public void initCombosForTestValidDiffServOptionsWork() {
        this.initSharedCombos();
    }

    public void testValidDiffServOptionsWork() throws Exception {
        String[] validNameOptions;
        String[] validIntegerOptions;
        for (String opt : validIntegerOptions = new String[]{"0", "1", "32", "62", "63"}) {
            this.testValidOptionsWork(DIFF_SERV + opt, "");
        }
        for (String opt : validNameOptions = new String[]{"CS0", "CS1", "CS2", "CS3", "CS4", "CS5", "CS6", "CS7", "EF", "AF11", "AF12", "AF13", "AF21", "AF22", "AF23", "AF31", "AF32", "AF33", "AF41", "AF42", "AF43"}) {
            this.testValidOptionsWork(DIFF_SERV + opt, "");
        }
    }

    public void initCombosForTestInvalidDiffServOptionDoesNotWork() {
        this.initSharedCombos();
    }

    public void testInvalidDiffServOptionsDoesNotWork() throws Exception {
        String[] invalidNameOptions;
        String[] invalidIntegerOptions;
        for (String opt : invalidIntegerOptions = new String[]{"-2", "-1", "64", "65", "100", "255"}) {
            this.testInvalidOptionsDoNotWork(DIFF_SERV + opt, "");
        }
        for (String opt : invalidNameOptions = new String[]{"hi", "", "A", "AF", "-AF21"}) {
            this.testInvalidOptionsDoNotWork(DIFF_SERV + opt, "");
        }
    }

    public void initCombosForTestValidTypeOfServiceOptionsWork() {
        this.initSharedCombos();
    }

    public void testValidTypeOfServiceOptionsWork() throws Exception {
        int[] validOptions;
        for (int opt : validOptions = new int[]{0, 1, 32, 100, 254, 255}) {
            this.testValidOptionsWork(TOS + opt, "");
        }
    }

    public void initCombosForTestInvalidTypeOfServiceOptionDoesNotWork() {
        this.initSharedCombos();
    }

    public void testInvalidTypeOfServiceOptionDoesNotWork() throws Exception {
        int[] invalidOptions;
        for (int opt : invalidOptions = new int[]{-2, -1, 256, 257}) {
            this.testInvalidOptionsDoNotWork(TOS + opt, "");
        }
    }

    public void initCombosForTestDiffServAndTypeOfServiceMutuallyExclusive() {
        this.initSharedCombos();
    }

    public void testDiffServAndTypeServiceMutuallyExclusive() {
        String msg = "It should not be possible to set both Differentiated Services and Type of Service options on the same connection URI.";
        this.testInvalidOptionsDoNotWork("&typeOfService=32&diffServ=", msg);
        this.testInvalidOptionsDoNotWork("&diffServ=32&typeOfService=32", msg);
    }

    public void initCombosForTestBadVersionNumberDoesNotWork() {
        this.initSharedCombos();
    }

    public void testBadVersionNumberDoesNotWork() throws Exception {
        this.testInvalidOptionsDoNotWork("&minmumWireFormatVersion=65535", "");
    }

    public void initCombosForTestBadPropertyNameFails() {
        this.initSharedCombos();
    }

    public void testBadPropertyNameFails() throws Exception {
        this.testInvalidOptionsDoNotWork("&cheese=abc", "");
    }

    private void initSharedCombos() {
        this.addCombinationValues("prefix", new Object[]{""});
        this.addCombinationValues("postfix", new Object[]{"?tcpNoDelay=true&keepAlive=true&soLinger=0"});
        this.addCombinationValues("postfix", new Object[]{"?tcpNoDelay=true&keepAlive=true&soLinger=-1"});
    }

    private void testValidOptionsWork(String options, String msg) {
        String uri = this.prefix + this.bindAddress + this.postfix + options;
        LOG.info("Connecting via: " + uri);
        try {
            this.connection = new ActiveMQConnectionFactory(uri).createConnection();
            this.connection.start();
        }
        catch (Exception unexpected) {
            TransportUriTest.fail((String)("Valid options '" + options + "' on URI '" + uri + "' should not have caused an exception to be thrown. " + msg + " Exception: " + String.valueOf(unexpected)));
        }
    }

    private void testInvalidOptionsDoNotWork(String options, String msg) {
        String uri = this.prefix + this.bindAddress + this.postfix + options;
        LOG.info("Connecting via: " + uri);
        try {
            this.connection = new ActiveMQConnectionFactory(uri).createConnection();
            this.connection.start();
            TransportUriTest.fail((String)("Invalid options '" + options + "' on URI '" + uri + "' should have caused an exception to be thrown. " + msg));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    public static Test suite() {
        return TransportUriTest.suite(TransportUriTest.class);
    }
}

