/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.List;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.test.JmsSendReceiveTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositePublishTest
extends JmsSendReceiveTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CompositePublishTest.class);
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;
    protected MessageConsumer[] consumers;
    protected List[] messageLists;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.sendConnection = this.createConnection();
        this.sendConnection.start();
        this.receiveConnection = this.createConnection();
        this.receiveConnection.start();
        LOG.info("Created sendConnection: " + String.valueOf(this.sendConnection));
        LOG.info("Created receiveConnection: " + String.valueOf(this.receiveConnection));
        this.session = this.sendConnection.createSession(false, 1);
        this.receiveSession = this.receiveConnection.createSession(false, 1);
        LOG.info("Created sendSession: " + String.valueOf(this.session));
        LOG.info("Created receiveSession: " + String.valueOf(this.receiveSession));
        this.producer = this.session.createProducer(null);
        LOG.info("Created producer: " + String.valueOf(this.producer));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        LOG.info("Created  consumer destination: " + String.valueOf(this.consumerDestination) + " of type: " + String.valueOf(this.consumerDestination.getClass()));
        LOG.info("Created  producer destination: " + String.valueOf(this.producerDestination) + " of type: " + String.valueOf(this.producerDestination.getClass()));
        Destination[] destinations = this.getDestinations();
        this.consumers = new MessageConsumer[destinations.length];
        this.messageLists = new List[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            Destination dest = destinations[i];
            this.messageLists[i] = this.createConcurrentList();
            this.consumers[i] = this.receiveSession.createConsumer(dest);
            this.consumers[i].setMessageListener(this.createMessageListener(i, this.messageLists[i]));
        }
        LOG.info("Started connections");
    }

    protected MessageListener createMessageListener(int i, final List<Message> messageList) {
        return new MessageListener(){

            public void onMessage(Message message) {
                CompositePublishTest.this.consumeMessage(message, messageList);
            }
        };
    }

    @Override
    protected String getSubject() {
        return this.getPrefix() + "FOO.BAR," + this.getPrefix() + "FOO.X.Y";
    }

    protected Destination[] getDestinations() {
        return new Destination[]{new ActiveMQTopic(this.getPrefix() + "FOO.BAR"), new ActiveMQTopic(this.getPrefix() + "FOO.*"), new ActiveMQTopic(this.getPrefix() + "FOO.X.Y")};
    }

    protected String getPrefix() {
        return super.getSubject() + ".";
    }

    @Override
    protected void assertMessagesAreReceived() throws JMSException {
        int i;
        this.waitForMessagesToBeDelivered();
        int size = this.messageLists.length;
        for (i = 0; i < size; ++i) {
            LOG.info("Message list: " + i + " contains: " + this.messageLists[i].size() + " message(s)");
        }
        size = this.messageLists.length;
        for (i = 0; i < size; ++i) {
            this.assertMessagesReceivedAreValid(this.messageLists[i]);
        }
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }
}

