/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.ObjectName;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestBase;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DurableSubscriptionOffline2Test
extends DurableSubscriptionOfflineTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionOffline2Test.class);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Boolean[]> getTestParameters() {
        Boolean[] f = new Boolean[]{Boolean.FALSE};
        Boolean[] t = new Boolean[]{Boolean.TRUE};
        ArrayList<Boolean[]> booleanChoices = new ArrayList<Boolean[]>();
        booleanChoices.add(f);
        booleanChoices.add(t);
        return booleanChoices;
    }

    public DurableSubscriptionOffline2Test(Boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
        LOG.info(">>>> running {} with keepDurableSubsActive: {}", (Object)this.testName.getMethodName(), (Object)this.keepDurableSubsActive);
    }

    @Test(timeout=60000L)
    public void testJMXCountersWithOfflineSubs() throws Exception {
        Connection con = this.createConnection("cliId1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", null, true);
        session.close();
        con.close();
        this.broker.stop();
        this.createBroker(false);
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            producer.send((Destination)this.topic, message);
        }
        session.close();
        con.close();
        con = this.createConnection("cliId1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", null, true);
        for (int i = 0; i < sent / 2; ++i) {
            Message m = consumer.receive(4000L);
            Assert.assertNotNull((String)("got message: " + i), (Object)m);
            LOG.info("Got :" + i + ", " + String.valueOf(m));
        }
        ObjectName activeDurableSubName = this.broker.getAdminView().getDurableTopicSubscribers()[0];
        LOG.info("active durable sub name: " + String.valueOf(activeDurableSubName));
        final DurableSubscriptionViewMBean durableSubscriptionView = (DurableSubscriptionViewMBean)this.broker.getManagementContext().newProxyInstance(activeDurableSubName, DurableSubscriptionViewMBean.class, true);
        Assert.assertTrue((String)"is active", (boolean)durableSubscriptionView.isActive());
        Assert.assertEquals((String)"all enqueued", (long)(this.keepDurableSubsActive ? 10L : 0L), (long)durableSubscriptionView.getEnqueueCounter());
        Assert.assertTrue((String)"correct waiting acks", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 5 == durableSubscriptionView.getMessageCountAwaitingAcknowledge();
            }
        }));
        Assert.assertEquals((String)"correct dequeue", (long)5L, (long)durableSubscriptionView.getDequeueCounter());
        ObjectName destinationName = this.broker.getAdminView().getTopics()[0];
        TopicViewMBean topicView = (TopicViewMBean)this.broker.getManagementContext().newProxyInstance(destinationName, TopicViewMBean.class, true);
        Assert.assertEquals((String)"correct enqueue", (long)10L, (long)topicView.getEnqueueCount());
        Assert.assertEquals((String)"topic view dequeue not updated", (long)5L, (long)topicView.getDequeueCount());
        Assert.assertEquals((String)"inflight", (long)5L, (long)topicView.getInFlightCount());
        session.close();
        con.close();
        ObjectName inActiveDurableSubName = this.broker.getAdminView().getInactiveDurableTopicSubscribers()[0];
        LOG.info("inactive durable sub name: " + String.valueOf(inActiveDurableSubName));
        DurableSubscriptionViewMBean durableSubscriptionView1 = (DurableSubscriptionViewMBean)this.broker.getManagementContext().newProxyInstance(inActiveDurableSubName, DurableSubscriptionViewMBean.class, true);
        Assert.assertTrue((String)"is not active", (!durableSubscriptionView1.isActive() ? 1 : 0) != 0);
        Assert.assertEquals((String)"all enqueued", (long)(this.keepDurableSubsActive ? 10L : 0L), (long)durableSubscriptionView1.getEnqueueCounter());
        Assert.assertEquals((String)"correct awaiting ack", (long)0L, (long)durableSubscriptionView1.getMessageCountAwaitingAcknowledge());
        Assert.assertEquals((String)"correct dequeue", (long)(this.keepDurableSubsActive ? 5L : 0L), (long)durableSubscriptionView1.getDequeueCounter());
        Assert.assertEquals((String)"correct enqueue", (long)10L, (long)topicView.getEnqueueCount());
        Assert.assertEquals((String)"topic view dequeue not updated", (long)5L, (long)topicView.getDequeueCount());
        Assert.assertEquals((String)"inflight back to 0 after deactivate", (long)0L, (long)topicView.getInFlightCount());
        con = this.createConnection("cliId1");
        session = con.createSession(false, 1);
        consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", null, true);
        for (int i = 0; i < sent / 2; ++i) {
            Message m = consumer.receive(30000L);
            Assert.assertNotNull((String)("got message: " + i), (Object)m);
            LOG.info("Got :" + i + ", " + String.valueOf(m));
        }
        activeDurableSubName = this.broker.getAdminView().getDurableTopicSubscribers()[0];
        LOG.info("durable sub name: " + String.valueOf(activeDurableSubName));
        final DurableSubscriptionViewMBean durableSubscriptionView2 = (DurableSubscriptionViewMBean)this.broker.getManagementContext().newProxyInstance(activeDurableSubName, DurableSubscriptionViewMBean.class, true);
        Assert.assertTrue((String)"is active", (boolean)durableSubscriptionView2.isActive());
        Assert.assertEquals((String)"all enqueued", (long)(this.keepDurableSubsActive ? 10L : 0L), (long)durableSubscriptionView2.getEnqueueCounter());
        Assert.assertTrue((String)"correct dequeue", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                long val = durableSubscriptionView2.getDequeueCounter();
                LOG.info("dequeue count:" + val);
                return 10L == val;
            }
        }));
    }
}

