/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.File;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.IOHelper;
import org.junit.Assert;
import org.junit.Test;

public class DurableSubscriptionPartialAckTest {
    private BrokerService createBroker() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((String)("broker:(vm://" + this.getClass().getName() + ")"));
        broker.setBrokerName("broker");
        broker.setAdvisorySupport(false);
        File dir = broker.getBrokerDataDirectory();
        if (dir != null) {
            IOHelper.deleteChildren((File)dir);
        }
        return broker;
    }

    @Test
    public void test() throws Exception {
        TopicSubscriber subscriber;
        Session session;
        BrokerService broker = this.createBroker();
        broker.start();
        broker.waitUntilStarted();
        ActiveMQTopic topic = new ActiveMQTopic("TOPIC.TEST");
        String subName1 = "SUB1";
        String subName2 = "SUB2";
        int numberOfMessages = 10000;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(broker.getVmConnectorURI());
        try (Connection connection = connectionFactory.createConnection();){
            int i;
            connection.setClientID("CLIENT_ID");
            connection.start();
            session = connection.createSession(false, 4);
            subscriber = session.createDurableSubscriber((Topic)topic, subName1);
            session.createDurableSubscriber((Topic)topic, subName2).close();
            MessageProducer producer = session.createProducer((Destination)topic);
            for (i = 0; i < numberOfMessages; ++i) {
                ActiveMQTextMessage message = new ActiveMQTextMessage();
                message.setText(Integer.toString(i));
                producer.send((Message)message);
            }
            for (i = 0; i < numberOfMessages; ++i) {
                Message receivedMessage = subscriber.receive(1000L);
                Assert.assertNotNull((Object)receivedMessage);
                Assert.assertTrue((boolean)(receivedMessage instanceof TextMessage));
                Assert.assertEquals((Object)Integer.toString(i), (Object)((TextMessage)receivedMessage).getText());
                if (i % 2 != 0) continue;
                receivedMessage.acknowledge();
            }
        }
        broker.stop();
        broker.waitUntilStopped();
        broker.start();
        broker.waitUntilStarted();
        connection = connectionFactory.createConnection();
        try {
            connection.setClientID("CLIENT_ID");
            connection.start();
            session = connection.createSession(false, 4);
            subscriber = session.createDurableSubscriber((Topic)topic, subName1);
            for (int i = 1; i < numberOfMessages; i += 2) {
                Message receivedMessage = subscriber.receive(10000L);
                Assert.assertNotNull((Object)receivedMessage);
                Assert.assertTrue((boolean)(receivedMessage instanceof TextMessage));
                Assert.assertEquals((Object)Integer.toString(i), (Object)((TextMessage)receivedMessage).getText());
                receivedMessage.acknowledge();
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

