/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBrokersMultiClientsTest
extends JmsMultipleBrokersTestSupport
implements Thread.UncaughtExceptionHandler {
    public static final int BROKER_COUNT = 6;
    public static final int CONSUMER_COUNT = 25;
    public static final int PRODUCER_COUNT = 3;
    public static final int MESSAGE_COUNT = 20;
    private static final Logger LOG = LoggerFactory.getLogger(MultiBrokersMultiClientsTest.class);
    protected Map<String, MessageConsumer> consumerMap;
    Map<Thread, Throwable> unhandeledExceptions = new HashMap<Thread, Throwable>();

    public void testTopicAllConnected() throws Exception {
        int j;
        int i;
        this.bridgeAllBrokers();
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        CountDownLatch latch = new CountDownLatch(54000);
        for (i = 1; i <= 6; ++i) {
            for (j = 0; j < 25; ++j) {
                this.consumerMap.put("Consumer:" + i + ":" + j, this.createConsumer("Broker" + i, (Destination)dest, latch));
            }
        }
        for (i = 1; i <= 6; ++i) {
            this.assertConsumersConnect("Broker" + i, (Destination)dest, 30, 65000L);
        }
        for (i = 1; i <= 6; ++i) {
            for (j = 0; j < 3; ++j) {
                this.sendMessages("Broker" + i, (Destination)dest, 20);
            }
        }
        MultiBrokersMultiClientsTest.assertTrue((String)("Missing " + latch.getCount() + " messages"), (boolean)latch.await(45L, TimeUnit.SECONDS));
        for (i = 1; i <= 6; ++i) {
            for (j = 0; j < 25; ++j) {
                MessageIdList msgs = this.getConsumerMessages("Broker" + i, this.consumerMap.get("Consumer:" + i + ":" + j));
                MultiBrokersMultiClientsTest.assertEquals((int)360, (int)msgs.getMessageCount());
            }
        }
        this.assertNoUnhandeledExceptions();
    }

    private void assertNoUnhandeledExceptions() {
        for (Map.Entry<Thread, Throwable> e : this.unhandeledExceptions.entrySet()) {
            LOG.error("Thread:" + String.valueOf(e.getKey()) + " Had unexpected: " + String.valueOf(e.getValue()));
        }
        MultiBrokersMultiClientsTest.assertTrue((String)("There are no unhandelled exceptions, see: log for detail on: " + String.valueOf(this.unhandeledExceptions)), (boolean)this.unhandeledExceptions.isEmpty());
    }

    public void testQueueAllConnected() throws Exception {
        int j;
        int i;
        this.bridgeAllBrokers();
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        CountDownLatch latch = new CountDownLatch(360);
        for (i = 1; i <= 6; ++i) {
            for (j = 0; j < 25; ++j) {
                this.consumerMap.put("Consumer:" + i + ":" + j, this.createConsumer("Broker" + i, (Destination)dest, latch));
            }
        }
        for (i = 1; i <= 6; ++i) {
            this.assertConsumersConnect("Broker" + i, (Destination)dest, 30, 65000L);
        }
        for (i = 1; i <= 6; ++i) {
            for (j = 0; j < 3; ++j) {
                this.sendMessages("Broker" + i, (Destination)dest, 20);
            }
        }
        MultiBrokersMultiClientsTest.assertTrue((String)("Missing " + latch.getCount() + " messages"), (boolean)latch.await(45L, TimeUnit.SECONDS));
        int totalMsg = 0;
        for (int i2 = 1; i2 <= 6; ++i2) {
            for (int j2 = 0; j2 < 25; ++j2) {
                MessageIdList msgs = this.getConsumerMessages("Broker" + i2, this.consumerMap.get("Consumer:" + i2 + ":" + j2));
                totalMsg += msgs.getMessageCount();
            }
        }
        MultiBrokersMultiClientsTest.assertEquals((int)360, (int)totalMsg);
        this.assertNoUnhandeledExceptions();
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.unhandeledExceptions.clear();
        Thread.setDefaultUncaughtExceptionHandler(this);
        for (int i = 1; i <= 6; ++i) {
            this.createBroker(new URI("broker:()/Broker" + i + "?persistent=false&useJmx=false"));
        }
        this.consumerMap = new HashMap<String, MessageConsumer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Map<Thread, Throwable> map = this.unhandeledExceptions;
        synchronized (map) {
            this.unhandeledExceptions.put(t, e);
        }
    }
}

