/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueueRepeaterTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QueueRepeaterTest.class);
    private volatile String receivedText;
    private Session producerSession;
    private Session consumerSession;
    private Destination queue;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Connection connection;
    private CountDownLatch latch = new CountDownLatch(1);

    public void testTransaction() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = factory.createConnection();
        this.queue = new ActiveMQQueue(((Object)((Object)this)).getClass().getName() + "." + this.getName());
        this.producerSession = this.connection.createSession(false, 1);
        this.consumerSession = this.connection.createSession(true, 0);
        this.producer = this.producerSession.createProducer(this.queue);
        this.consumer = this.consumerSession.createConsumer(this.queue);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message m) {
                try {
                    TextMessage tm = (TextMessage)m;
                    QueueRepeaterTest.this.receivedText = tm.getText();
                    QueueRepeaterTest.this.latch.countDown();
                    LOG.info("consumer received message :" + QueueRepeaterTest.this.receivedText);
                    QueueRepeaterTest.this.consumerSession.commit();
                    LOG.info("committed transaction");
                }
                catch (JMSException e) {
                    try {
                        QueueRepeaterTest.this.consumerSession.rollback();
                        LOG.info("rolled back transaction");
                    }
                    catch (JMSException e1) {
                        LOG.info(e1.toString());
                        e1.printStackTrace();
                    }
                    LOG.info(e.toString());
                    e.printStackTrace();
                }
            }
        });
        this.connection.start();
        TextMessage tm = null;
        try {
            tm = this.producerSession.createTextMessage();
            tm.setText("Hello, " + String.valueOf(new Date()));
            this.producer.send((Message)tm);
            LOG.info("producer sent message :" + tm.getText());
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        LOG.info("Waiting for latch");
        this.latch.await(2L, TimeUnit.SECONDS);
        QueueRepeaterTest.assertNotNull((Object)this.receivedText);
        LOG.info("test completed, destination=" + this.receivedText);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

