/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicProducerToSubFileCursorTest
extends TestCase
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(TopicProducerToSubFileCursorTest.class);
    private static final String brokerName = "testBroker";
    private static final String brokerUrl = "vm://testBroker";
    protected static final int destinationMemLimit = 0x200000;
    private static final AtomicLong produced = new AtomicLong();
    private static final AtomicLong consumed = new AtomicLong();
    private static final int numMessagesToSend = 20000;
    private BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName(brokerName);
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setSchedulerSupport(false);
        this.broker.setUseJmx(false);
        this.broker.setUseShutdownHook(false);
        this.broker.addConnector(brokerUrl);
        PolicyMap pm = new PolicyMap();
        PolicyEntry tpe = new PolicyEntry();
        tpe.setTopic(">");
        tpe.setMemoryLimit(0x200000L);
        tpe.setCursorMemoryHighWaterMark(2);
        tpe.setProducerFlowControl(true);
        tpe.setAdvisoryWhenFull(true);
        pm.setPolicyEntries(Arrays.asList(tpe));
        this.setDestinationPolicy(this.broker, pm);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x6400000L);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    protected void setDestinationPolicy(BrokerService broker, PolicyMap pm) {
        broker.setDestinationPolicy(pm);
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    public void testTopicProducerFlowControlNotUsedWhenSubSpoolsToDiskOnTwoPercentSystemUsage() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerUrl);
        connectionFactory.setAlwaysSyncSend(true);
        connectionFactory.setProducerWindowSize(1024);
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setAll(5000);
        connectionFactory.setPrefetchPolicy(prefetchPolicy);
        Connection c = connectionFactory.createConnection();
        c.start();
        Session listenerSession = c.createSession(false, 1);
        Destination destination = this.createDestination(listenerSession);
        listenerSession.createConsumer(destination).setMessageListener((MessageListener)new TopicProducerToSubFileCursorTest());
        final AtomicInteger blockedCounter = new AtomicInteger(0);
        listenerSession.createConsumer((Destination)new ActiveMQTopic("ActiveMQ.Advisory.FULL.>")).setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    LOG.error("Got full advisory, usageName: " + message.getStringProperty("usageName") + ", usageCount: " + message.getLongProperty("usageCount") + ", blockedCounter: " + blockedCounter.get());
                    blockedCounter.incrementAndGet();
                }
                catch (Exception error) {
                    error.printStackTrace();
                    LOG.error("missing advisory property", (Throwable)error);
                }
            }
        });
        final Session session = connectionFactory.createConnection().createSession(false, 1);
        final MessageProducer producer = session.createProducer(destination);
        Thread producingThread = new Thread("Producing Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (long i = 0L; i < 20000L; ++i) {
                        producer.send((Message)session.createTextMessage("test"));
                        long count = produced.incrementAndGet();
                        if (count % 10000L != 0L) continue;
                        LOG.info("Produced " + count + " messages");
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        producer.close();
                        session.close();
                    }
                    catch (Exception i) {}
                }
            }
        };
        producingThread.start();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return consumed.get() == 20000L;
            }
        }, (long)300000L);
        TopicProducerToSubFileCursorTest.assertEquals((String)"Didn't produce all messages", (long)20000L, (long)produced.get());
        TopicProducerToSubFileCursorTest.assertEquals((String)"Didn't consume all messages", (long)20000L, (long)consumed.get());
        TopicProducerToSubFileCursorTest.assertTrue((String)"Producer did not get blocked", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return blockedCounter.get() == 0;
            }
        }, (long)5000L));
    }

    protected Destination createDestination(Session listenerSession) throws Exception {
        return new ActiveMQTopic("test");
    }

    public void onMessage(Message message) {
        long count = consumed.incrementAndGet();
        if (count % 100L == 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (count % 10000L == 0L) {
            LOG.info("\tConsumed " + count + " messages");
        }
    }
}

