/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.test.TestSupport;
import org.apache.activemq.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicRedeliverTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TopicRedeliverTest.class);
    private static final int RECEIVE_TIMEOUT = 10000;
    protected int deliveryMode = 2;
    private IdGenerator idGen = new IdGenerator();

    public TopicRedeliverTest() {
    }

    public TopicRedeliverTest(String n) {
        super(n);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.topic = true;
    }

    public void testClientAcknowledge() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(false, 2);
        MessageConsumer consumer = consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sent1 = producerSession.createTextMessage();
        sent1.setText("msg1");
        producer.send((Message)sent1);
        TextMessage sent2 = producerSession.createTextMessage();
        sent1.setText("msg2");
        producer.send((Message)sent2);
        TextMessage sent3 = producerSession.createTextMessage();
        sent1.setText("msg3");
        producer.send((Message)sent3);
        consumer.receive(10000L);
        Message rec2 = consumer.receive(10000L);
        consumer.receive(10000L);
        rec2.acknowledge();
        TextMessage sent4 = producerSession.createTextMessage();
        sent4.setText("msg4");
        producer.send((Message)sent4);
        Message rec4 = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)rec4.equals(sent4));
        consumerSession.recover();
        rec4 = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)rec4.equals(sent4));
        TopicRedeliverTest.assertTrue((boolean)rec4.getJMSRedelivered());
        rec4.acknowledge();
        connection.close();
    }

    public void testRedilveredFlagSetOnRollback() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        Object consumer = null;
        consumer = this.topic ? consumerSession.createDurableSubscriber((Topic)destination, "TESTRED") : consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertFalse((boolean)recMsg.getJMSRedelivered());
        recMsg = consumer.receive(10000L);
        consumerSession.rollback();
        recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        connection.close();
    }

    public void testNoExceptionOnRedeliveryAckWithSimpleTopicConsumer() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        final AtomicBoolean gotException = new AtomicBoolean();
        connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                LOG.error("unexpected ex:" + String.valueOf((Object)exception));
                gotException.set(true);
            }
        });
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        MessageConsumer consumer = null;
        consumer = this.topic ? consumerSession.createConsumer((Destination)((Topic)destination)) : consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertFalse((boolean)recMsg.getJMSRedelivered());
        recMsg = consumer.receive(10000L);
        consumerSession.rollback();
        recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        consumerSession.rollback();
        recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        TopicRedeliverTest.assertTrue((boolean)recMsg.getJMSRedelivered());
        connection.close();
        TopicRedeliverTest.assertFalse((String)"no exception", (boolean)gotException.get());
    }

    public void xtestTransactionRollbackOnSessionClose() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        Object consumer = null;
        consumer = this.topic ? consumerSession.createDurableSubscriber((Topic)destination, "TESTRED") : consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertFalse((boolean)recMsg.getJMSRedelivered());
        consumerSession.close();
        consumerSession = connection.createSession(true, 2);
        consumer = consumerSession.createConsumer(destination);
        recMsg = consumer.receive(10000L);
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        connection.close();
    }

    public void testTransactionRollbackOnSend() throws Exception {
        Destination destination = this.createDestination(((Object)((Object)this)).getClass().getName());
        Connection connection = this.createConnection();
        connection.setClientID(this.idGen.generateId());
        connection.start();
        Session consumerSession = connection.createSession(true, 2);
        MessageConsumer consumer = consumerSession.createConsumer(destination);
        Session producerSession = connection.createSession(true, 1);
        MessageProducer producer = producerSession.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        TextMessage sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg1");
        producer.send((Message)sentMsg);
        producerSession.commit();
        Message recMsg = consumer.receive(10000L);
        consumerSession.commit();
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg2");
        producer.send((Message)sentMsg);
        producerSession.rollback();
        sentMsg = producerSession.createTextMessage();
        sentMsg.setText("msg3");
        producer.send((Message)sentMsg);
        producerSession.commit();
        recMsg = consumer.receive(10000L);
        TopicRedeliverTest.assertTrue((boolean)recMsg.equals(sentMsg));
        consumerSession.commit();
        connection.close();
    }
}

