/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class JmsCreateConsumerInOnMessageTest {
    private Connection connection;
    private ActiveMQConnectionFactory factory;
    @Rule
    public final TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        this.connection = this.factory.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Test(timeout=60000L)
    public void testCreateConsumer() throws Exception {
        final CountDownLatch done = new CountDownLatch(1);
        Session publisherSession = this.connection.createSession(false, 1);
        final Session consumerSession = this.connection.createSession(false, 1);
        final Topic topic = publisherSession.createTopic("Test.Topic");
        MessageConsumer consumer = consumerSession.createConsumer((Destination)topic);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    consumerSession.createConsumer((Destination)topic);
                    consumerSession.createProducer((Destination)topic);
                    done.countDown();
                }
                catch (Exception ex) {
                    Assert.assertTrue((boolean)false);
                }
            }
        });
        MessageProducer producer = publisherSession.createProducer((Destination)topic);
        this.connection.start();
        producer.send((Message)publisherSession.createTextMessage("test"));
        Assert.assertTrue((String)"Should have finished onMessage", (boolean)done.await(5L, TimeUnit.SECONDS));
    }
}

