/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;

public class JmsTestSupport
extends CombinationTestSupport {
    private static final AtomicLong TEST_COUNTER = new AtomicLong();
    public String userName;
    public String password;
    public String messageTextPrefix = "";
    protected ConnectionFactory factory;
    protected ActiveMQConnection connection;
    protected BrokerService broker;
    protected List<Connection> connections = Collections.synchronizedList(new ArrayList());

    protected ActiveMQDestination createDestination(Session session, byte type) throws JMSException {
        String testMethod = this.getName();
        if (testMethod.indexOf(" ") > 0) {
            testMethod = testMethod.substring(0, testMethod.indexOf(" "));
        }
        String name = "TEST." + ((Object)((Object)this)).getClass().getName() + "." + testMethod + "." + TEST_COUNTER.getAndIncrement();
        switch (type) {
            case 1: {
                return (ActiveMQDestination)session.createQueue(name);
            }
            case 2: {
                return (ActiveMQDestination)session.createTopic(name);
            }
            case 5: {
                return (ActiveMQDestination)session.createTemporaryQueue();
            }
            case 6: {
                return (ActiveMQDestination)session.createTemporaryTopic();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    protected void sendMessages(Destination destination, int count) throws Exception {
        ConnectionFactory factory = this.createConnectionFactory();
        Connection connection = factory.createConnection();
        connection.start();
        this.sendMessages(connection, destination, count);
        connection.close();
    }

    protected void sendMessages(Connection connection, Destination destination, int count) throws JMSException {
        Session session = connection.createSession(false, 1);
        this.sendMessages(session, destination, count);
        session.close();
    }

    protected void sendMessages(Session session, Destination destination, int count) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        this.sendMessages(session, producer, count);
        producer.close();
    }

    protected void sendMessages(Session session, MessageProducer producer, int count) throws JMSException {
        for (int i = 0; i < count; ++i) {
            producer.send((Message)session.createTextMessage(this.messageTextPrefix + i));
        }
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService service = BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false"));
        service.getManagementContext().setCreateConnector(false);
        return service;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        this.broker = this.createBroker();
        this.broker.start();
        this.factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
        this.connections.add((Connection)this.connection);
    }

    protected void tearDown() throws Exception {
        Iterator<Connection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            Connection conn = iter.next();
            try {
                conn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            iter.remove();
        }
        this.broker.stop();
        super.tearDown();
    }

    protected void safeClose(Connection c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void safeClose(Session s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void safeClose(MessageConsumer c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void safeClose(MessageProducer p) {
        try {
            p.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void profilerPause(String prompt) throws IOException {
        if (System.getProperty("profiler") != null) {
            this.pause(prompt);
        }
    }

    protected void pause(String prompt) throws IOException {
        System.out.println();
        System.out.println(prompt + "> Press enter to continue: ");
        while (System.in.read() != 10) {
        }
    }
}

