/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.transport.failover.FailoverTransport;

public class DurablePersistentFalseRestartTest
extends BrokerRestartTestSupport {
    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        super.configureBroker(broker);
        broker.setPersistent(false);
        broker.setPersistenceAdapter((PersistenceAdapter)new KahaDBPersistenceAdapter());
        broker.addConnector("tcp://0.0.0.0:0");
    }

    public void testValidateNoPersistenceForDurableAfterRestart() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + ")");
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.setClientID("clientId");
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic(this.queueName);
        TopicSubscriber consumer = session.createDurableSubscriber(destination, "subscriberName");
        this.populateDestination(10, (Destination)destination, (Connection)connection);
        this.restartBroker();
        ((FailoverTransport)connection.getTransport().narrow(FailoverTransport.class)).add(true, ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        TextMessage msg = (TextMessage)consumer.receive(8000L);
        DurablePersistentFalseRestartTest.assertNull((String)("did not get a message when persistent=false, message: " + msg), (Object)msg);
        connection.close();
    }

    private void populateDestination(int nbMessages, Destination destination, Connection connection) throws JMSException {
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        for (int i = 1; i <= nbMessages; ++i) {
            producer.send((Message)session.createTextMessage("<hello id='" + i + "'/>"));
        }
        producer.close();
        session.close();
    }

    public static Test suite() {
        return DurablePersistentFalseRestartTest.suite(DurablePersistentFalseRestartTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DurablePersistentFalseRestartTest.suite());
    }
}

