/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryRecoveryTest {
    static final Logger LOG = LoggerFactory.getLogger(RedeliveryRecoveryTest.class);
    ActiveMQConnection connection;
    BrokerService broker = null;
    String queueName = "redeliveryRecoveryQ";

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.configureBroker(this.broker);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.broker.stop();
    }

    protected void configureBroker(BrokerService broker) throws Exception {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setPersistJMSRedelivered(true);
        policyMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(policyMap);
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)broker.getPersistenceAdapter();
        kahaDBPersistenceAdapter.setForceRecoverIndex(true);
        broker.addConnector("tcp://0.0.0.0:0");
    }

    @Test
    public void testValidateRedeliveryFlagAfterRestart() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.prefetchPolicy.all=0");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue destination = session.createQueue(this.queueName);
        this.populateDestination(1, (Destination)destination, (Connection)this.connection);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message msg = consumer.receive(5000L);
        LOG.info("got: " + msg);
        Assert.assertNotNull((String)"got the message", (Object)msg);
        Assert.assertFalse((String)"got the message", (boolean)msg.getJMSRedelivered());
        consumer.close();
        this.connection.close();
        this.restartBroker();
        connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.prefetchPolicy.all=0");
        this.connection = (ActiveMQConnection)connectionFactory.createConnection();
        this.connection.start();
        session = this.connection.createSession(false, 2);
        destination = session.createQueue(this.queueName);
        consumer = session.createConsumer((Destination)destination);
        msg = consumer.receive(5000L);
        LOG.info("got: " + msg);
        Assert.assertNotNull((String)"got the message", (Object)msg);
        Assert.assertTrue((String)"got the message has redelivered flag", (boolean)msg.getJMSRedelivered());
        this.connection.close();
    }

    private void restartBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createRestartedBroker();
        this.broker.start();
    }

    private BrokerService createRestartedBroker() throws Exception {
        this.broker = new BrokerService();
        this.configureBroker(this.broker);
        return this.broker;
    }

    private void populateDestination(int nbMessages, Destination destination, Connection connection) throws JMSException {
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(2);
        for (int i = 1; i <= nbMessages; ++i) {
            producer.send((Message)session.createTextMessage("<hello id='" + i + "'/>"));
        }
        producer.close();
        session.close();
    }
}

