/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeLargeMessageTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeLargeMessageTest.class);
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected String clientID = "foo";
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;

    public void testPurgeLargeMessage() throws Exception {
        int messageCount = 600;
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.clientID);
        this.connection.start();
        Session session = this.connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = this.createTextMessage(session, 5000L);
        for (int i = 0; i < 600; ++i) {
            producer.send((Message)message);
        }
        Object objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = (String)objectNameStr + ",destinationType=Queue,destinationName=" + this.getDestinationString();
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName((String)objectNameStr);
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long count = proxy.getQueueSize();
        PurgeLargeMessageTest.assertEquals((String)"Queue size", (long)count, (long)600L);
        proxy.browse();
        proxy.purge();
        count = proxy.getQueueSize();
        PurgeLargeMessageTest.assertEquals((String)"Queue size", (long)count, (long)0L);
        PurgeLargeMessageTest.assertEquals((String)"Browse size", (int)proxy.browseMessages().size(), (int)0);
        producer.close();
    }

    private TextMessage createTextMessage(Session session, long textSize) throws JMSException {
        StringBuilder stringBuilder = new StringBuilder();
        for (long i = 0L; i < textSize; ++i) {
            stringBuilder.append('A');
        }
        return session.createTextMessage(stringBuilder.toString());
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            this.echo("Bean Registered: " + objectName);
        } else {
            PurgeLargeMessageTest.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.setEnableStatistics(true);
        answer.addConnector(this.bindAddress);
        answer.deleteAllMessages();
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setQueue(">");
        pe.setUseCache(false);
        pe.setMemoryLimit(1000000L);
        pe.setExpireMessagesPeriod(0L);
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        answer.setDestinationPolicy(policyMap);
        return answer;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    protected void echo(String text) {
        LOG.info(text);
    }

    @Override
    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName(true);
    }
}

