/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import jakarta.jms.Connection;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursorTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.util.SubscriptionKey;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MemoryPendingMessageCursorTest
extends AbstractPendingMessageCursorTest {
    protected static final Logger LOG = LoggerFactory.getLogger(MemoryPendingMessageCursorTest.class);

    @Parameterized.Parameters(name="prioritizedMessages={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    public MemoryPendingMessageCursorTest(boolean prioritizedMessages) {
        super(prioritizedMessages);
    }

    @Override
    protected void initPersistence(BrokerService brokerService) throws IOException {
        this.broker.setPersistent(false);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
    }

    @Override
    @Test
    public void testMessageSizeOneDurable() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI).createConnection();
        connection.setClientID("clientId");
        connection.start();
        SubscriptionKey subKey = new SubscriptionKey("clientId", "sub1");
        Topic dest = this.publishTestMessagesDurable(connection, new String[]{"sub1"}, 200, publishedMessageSize, 2);
        this.verifyPendingStats(dest, subKey, 200, publishedMessageSize.get());
        this.verifyStoreStats((Destination)dest, 100, publishedMessageSize.get());
        this.consumeDurableTestMessages(connection, "sub1", 100, publishedMessageSize);
        this.verifyPendingStats(dest, subKey, 100, publishedMessageSize.get());
        this.verifyStoreStats((Destination)dest, 100, publishedMessageSize.get());
        connection.close();
    }

    @Override
    @Test
    public void testMessageSizeTwoDurables() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI).createConnection();
        connection.setClientID("clientId");
        connection.start();
        Topic dest = this.publishTestMessagesDurable(connection, new String[]{"sub1", "sub2"}, 200, publishedMessageSize, 2);
        SubscriptionKey subKey = new SubscriptionKey("clientId", "sub1");
        this.verifyPendingStats(dest, subKey, 200, publishedMessageSize.get());
        this.consumeDurableTestMessages(connection, "sub1", 200, publishedMessageSize);
        SubscriptionKey subKey2 = new SubscriptionKey("clientId", "sub2");
        this.verifyPendingStats(dest, subKey, 0, 0L);
        this.verifyPendingStats(dest, subKey2, 200, publishedMessageSize.get());
        this.verifyStoreStats((Destination)dest, 0, publishedMessageSize.get());
        connection.stop();
    }

    @Override
    @Test
    public void testMessageSizeOneDurablePartialConsumption() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI).createConnection();
        connection.setClientID("clientId");
        connection.start();
        SubscriptionKey subKey = new SubscriptionKey("clientId", "sub1");
        Topic dest = this.publishTestMessagesDurable(connection, new String[]{"sub1"}, 200, publishedMessageSize, 2);
        this.verifyPendingStats(dest, subKey, 200, publishedMessageSize.get());
        this.verifyStoreStats((Destination)dest, 100, publishedMessageSize.get());
        this.consumeDurableTestMessages(connection, "sub1", 50, publishedMessageSize);
        this.verifyPendingStats(dest, subKey, 150, publishedMessageSize.get());
        this.verifyStoreStats((Destination)dest, 100, 10000L);
        connection.close();
    }
}

