/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.annotation.Resource;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.virtual.SimpleMessageListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"virtual-topic-network-test.xml"})
public class MessageDestinationVirtualTopicTest {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDestinationVirtualTopicTest.class);
    private SimpleMessageListener listener1;
    private SimpleMessageListener listener2;
    private SimpleMessageListener listener3;
    @Resource(name="broker1")
    private BrokerService broker1;
    @Resource(name="broker2")
    private BrokerService broker2;
    private MessageProducer producer;
    private Session session1;

    public void init() throws JMSException {
        ActiveMQConnectionFactory broker2ConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:62616");
        Connection connection2 = broker2ConnectionFactory.createConnection();
        connection2.start();
        Session session2 = connection2.createSession(false, 1);
        Queue consumerDQueue = session2.createQueue("Consumer.D.VirtualTopic.T1");
        MessageConsumer consumer = session2.createConsumer((Destination)consumerDQueue);
        this.listener2 = new SimpleMessageListener();
        consumer.setMessageListener((MessageListener)this.listener2);
        ActiveMQConnectionFactory broker1ConnectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        Connection connection1 = broker1ConnectionFactory.createConnection();
        connection1.start();
        this.session1 = connection1.createSession(false, 1);
        Queue consumerCQueue = this.session1.createQueue("Consumer.C.VirtualTopic.T1");
        MessageConsumer consumer1 = this.session1.createConsumer((Destination)consumerCQueue);
        this.listener1 = new SimpleMessageListener();
        consumer1.setMessageListener((MessageListener)this.listener1);
        Queue consumer3Queue = this.session1.createQueue("Consumer.A.VirtualTopic.T2");
        MessageConsumer consumerD = this.session1.createConsumer((Destination)consumer3Queue);
        this.listener3 = new SimpleMessageListener();
        consumerD.setMessageListener((MessageListener)this.listener3);
        Topic virtualTopicT1 = this.session1.createTopic("VirtualTopic.T1,VirtualTopic.T2");
        this.producer = this.session1.createProducer((Destination)virtualTopicT1);
    }

    @Test
    public void testDestinationNames() throws Exception {
        LOG.info("Started waiting for broker 1 and 2");
        this.broker1.waitUntilStarted();
        this.broker2.waitUntilStarted();
        LOG.info("Broker 1 and 2 have started");
        this.init();
        CountDownLatch monitor = new CountDownLatch(3);
        this.listener1.setCountDown(monitor);
        this.listener2.setCountDown(monitor);
        this.listener3.setCountDown(monitor);
        LOG.info("Sending message");
        TextMessage message = this.session1.createTextMessage("Hello World !");
        this.producer.send((Message)message);
        LOG.info("Waiting for message reception");
        monitor.await();
        String lastJMSDestination2 = this.listener2.getLastJMSDestination();
        System.err.println(lastJMSDestination2);
        String lastJMSDestination1 = this.listener1.getLastJMSDestination();
        System.err.println(lastJMSDestination1);
        String lastJMSDestination3 = this.listener3.getLastJMSDestination();
        System.err.println(lastJMSDestination3);
        Assert.assertEquals((Object)"queue://Consumer.D.VirtualTopic.T1", (Object)lastJMSDestination2);
        Assert.assertEquals((Object)"queue://Consumer.C.VirtualTopic.T1", (Object)lastJMSDestination1);
        Assert.assertEquals((Object)"topic://VirtualTopic.T2", (Object)lastJMSDestination3);
    }
}

