/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2645Test
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2645Test.class);
    private static final String QUEUE_NAME = "test.daroo.q";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWaitForTransportInterruptionProcessingHang() throws Exception {
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory("failover:(" + this.bindAddress + ")");
        Connection connection = fac.createConnection();
        try {
            final Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue(QUEUE_NAME);
            final MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            connection.start();
            producer.send((Message)session.createTextMessage("test"));
            final CountDownLatch afterRestart = new CountDownLatch(1);
            final CountDownLatch twoNewMessages = new CountDownLatch(1);
            final CountDownLatch thirdMessageReceived = new CountDownLatch(1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(QUEUE_NAME));
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        afterRestart.await();
                        TextMessage txtMsg = (TextMessage)message;
                        if (txtMsg.getText().equals("test")) {
                            producer.send((Message)session.createTextMessage("test 1"));
                            TimeUnit.SECONDS.sleep(5L);
                            producer.send((Message)session.createTextMessage("test 2"));
                            LOG.info("Two new messages produced.");
                            twoNewMessages.countDown();
                        } else if (txtMsg.getText().equals("test 3")) {
                            thirdMessageReceived.countDown();
                        }
                    }
                    catch (Exception e) {
                        LOG.error(e.toString());
                        throw new RuntimeException(e);
                    }
                }
            });
            LOG.info("Stopping broker....");
            this.broker.stop();
            LOG.info("Creating new broker...");
            this.broker = this.createBroker();
            this.startBroker();
            this.broker.waitUntilStarted();
            afterRestart.countDown();
            AMQ2645Test.assertTrue((String)"Consumer is deadlocked!", (boolean)twoNewMessages.await(60L, TimeUnit.SECONDS));
            producer.send((Message)session.createTextMessage("test 3"));
            AMQ2645Test.assertTrue((String)"Consumer got third message after block", (boolean)thirdMessageReceived.await(60L, TimeUnit.SECONDS));
        }
        finally {
            this.broker.stop();
        }
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://0.0.0.0:61617";
        super.setUp();
    }
}

