/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3445Test {
    private ConnectionFactory connectionFactory;
    private BrokerService broker;
    private String connectionUri;
    private final String queueName = "Consumer.MyApp.VirtualTopic.FOO";
    private final String topicName = "VirtualTopic.FOO";

    @Before
    public void startBroker() throws Exception {
        this.createBroker(true);
    }

    private void createBroker(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(deleteMessages);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new JDBCPersistenceAdapter());
        this.broker.setAdvisorySupport(false);
        this.broker.addConnector("tcp://0.0.0.0:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
    }

    private void restartBroker() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
        this.createBroker(false);
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void testJDBCRetiansDestinationAfterRestart() throws Exception {
        this.broker.getAdminView().addQueue("Consumer.MyApp.VirtualTopic.FOO");
        this.broker.getAdminView().addTopic("VirtualTopic.FOO");
        Assert.assertTrue((boolean)this.findDestination("Consumer.MyApp.VirtualTopic.FOO", false));
        Assert.assertTrue((boolean)this.findDestination("VirtualTopic.FOO", true));
        QueueViewMBean queue = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)0L, (long)queue.getQueueSize());
        this.restartBroker();
        Assert.assertTrue((boolean)this.findDestination("Consumer.MyApp.VirtualTopic.FOO", false));
        queue = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)0L, (long)queue.getQueueSize());
        this.sendMessage();
        this.restartBroker();
        Assert.assertTrue((boolean)this.findDestination("Consumer.MyApp.VirtualTopic.FOO", false));
        queue = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)1L, (long)queue.getQueueSize());
        this.sendMessage();
        Assert.assertEquals((long)2L, (long)queue.getQueueSize());
        this.restartBroker();
        Assert.assertTrue((boolean)this.findDestination("Consumer.MyApp.VirtualTopic.FOO", false));
        queue = this.getProxyToQueueViewMBean();
        Assert.assertEquals((long)2L, (long)queue.getQueueSize());
    }

    private void sendMessage() throws Exception {
        Connection connection = this.connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createTopic("VirtualTopic.FOO"));
        producer.setDeliveryMode(2);
        producer.send((Message)session.createTextMessage("Testing"));
        producer.close();
        connection.close();
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws Exception {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:destinationType=Queue,destinationName=Consumer.MyApp.VirtualTopic.FOO,type=Broker,brokerName=localhost");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    private boolean findDestination(String name, boolean topic) throws Exception {
        ObjectName[] destinations = topic ? this.broker.getAdminView().getTopics() : this.broker.getAdminView().getQueues();
        for (ObjectName destination : destinations) {
            if (!destination.toString().contains(name)) continue;
            return true;
        }
        return false;
    }
}

