/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ResourceAllocationException;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3903Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ3903Test.class);
    private static final String bindAddress = "tcp://0.0.0.0:0";
    private BrokerService broker;
    private ActiveMQConnectionFactory cf;
    private static final int MESSAGE_COUNT = 100;

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        String address = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.cf = new ActiveMQConnectionFactory(address);
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void testAdvisoryForFastGenericProducer() throws Exception {
        this.doTestAdvisoryForFastProducer(true);
    }

    @Test
    public void testAdvisoryForFastDedicatedProducer() throws Exception {
        this.doTestAdvisoryForFastProducer(false);
    }

    public void doTestAdvisoryForFastProducer(boolean genericProducer) throws Exception {
        Connection connection = this.cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        ActiveMQTopic advisoryTopic = AdvisorySupport.getFastProducerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        ActiveMQTopic advisoryWhenFullTopic = AdvisorySupport.getFullAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = session.createConsumer((Destination)advisoryTopic);
        MessageConsumer advisoryWhenFullConsumer = session.createConsumer((Destination)advisoryWhenFullTopic);
        MessageProducer producer = session.createProducer((Destination)(genericProducer ? null : queue));
        try {
            for (int i = 0; i < 100; ++i) {
                BytesMessage m = session.createBytesMessage();
                m.writeBytes(new byte[1024]);
                if (genericProducer) {
                    producer.send((Destination)queue, (Message)m, 2, 4, 0L);
                    continue;
                }
                producer.send((Message)m);
            }
        }
        catch (ResourceAllocationException i) {
            // empty catch block
        }
        Message advCmsg = advisoryConsumer.receive(4000L);
        Assert.assertNotNull((Object)advCmsg);
        advCmsg = advisoryWhenFullConsumer.receive(4000L);
        Assert.assertNotNull((Object)advCmsg);
        connection.close();
        LOG.debug("Connection closed, destinations should now become inactive.");
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setUseJmx(false);
        PolicyEntry entry = new PolicyEntry();
        entry.setAdvisoryForFastProducers(true);
        entry.setAdvisoryWhenFull(true);
        entry.setMemoryLimit(10000L);
        PolicyMap map = new PolicyMap();
        map.setDefaultEntry(entry);
        answer.setDestinationPolicy(map);
        answer.addConnector(bindAddress);
        answer.getSystemUsage().setSendFailIfNoSpace(true);
        return answer;
    }
}

