/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.transport.vm.VMTransportFactory;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4222Test
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4222Test.class);
    protected BrokerService brokerService;

    protected void setUp() throws Exception {
        super.setUp();
        this.topic = false;
        this.brokerService = this.createBroker();
    }

    protected void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker:()/localhost?persistent=false"));
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    public void testTempQueueCleanedUp() throws Exception {
        jakarta.jms.Destination requestQueue = this.createDestination();
        Connection producerConnection = this.createConnection();
        producerConnection.start();
        Session producerSession = producerConnection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer(requestQueue);
        TemporaryQueue replyTo = producerSession.createTemporaryQueue();
        MessageConsumer producerSessionConsumer = producerSession.createConsumer((jakarta.jms.Destination)replyTo);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        producerSessionConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    if (message instanceof TextMessage) {
                        LOG.info("You got a message: " + ((TextMessage)message).getText());
                        countDownLatch.countDown();
                    }
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        });
        producer.send(this.createRequest(producerSession, (jakarta.jms.Destination)replyTo));
        Connection consumerConnection = this.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        MessageConsumer consumer = consumerSession.createConsumer(requestQueue);
        final MessageProducer consumerProducer = consumerSession.createProducer(null);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    consumerProducer.send(message.getJMSReplyTo(), message);
                }
                catch (JMSException e) {
                    LOG.error("error sending a response on the temp queue");
                    e.printStackTrace();
                }
            }
        });
        countDownLatch.await(2L, TimeUnit.SECONDS);
        Destination tempDestination = AMQ4222Test.getDestination(this.brokerService, (ActiveMQDestination)replyTo);
        AMQ4222Test.assertNotNull((Object)tempDestination);
        producer.close();
        producerSession.close();
        producerConnection.close();
        tempDestination = AMQ4222Test.getDestination(this.brokerService, (ActiveMQDestination)replyTo);
        AMQ4222Test.assertNull((Object)tempDestination);
        final TransportConnector connector = (TransportConnector)VMTransportFactory.CONNECTORS.get("localhost");
        AMQ4222Test.assertNotNull((Object)connector);
        AMQ4222Test.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return connector.getConnections().size() == 1;
            }
        }));
        TransportConnection transportConnection = (TransportConnection)connector.getConnections().get(0);
        Map<ProducerId, ProducerBrokerExchange> exchanges = this.getProducerExchangeFromConn(transportConnection);
        AMQ4222Test.assertEquals((int)1, (int)exchanges.size());
        ProducerBrokerExchange exchange = exchanges.values().iterator().next();
        AMQ4222Test.assertNull((Object)exchange.getRegionDestination());
        AMQ4222Test.assertNull((Object)exchange.getRegion());
    }

    private Map<ProducerId, ProducerBrokerExchange> getProducerExchangeFromConn(TransportConnection transportConnection) throws NoSuchFieldException, IllegalAccessException {
        Field f = TransportConnection.class.getDeclaredField("producerExchanges");
        f.setAccessible(true);
        Map producerExchanges = (Map)f.get(transportConnection);
        return producerExchanges;
    }

    private Message createRequest(Session session, jakarta.jms.Destination replyTo) throws JMSException {
        TextMessage message = session.createTextMessage("Payload");
        message.setJMSReplyTo(replyTo);
        return message;
    }
}

