/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4356Test {
    private static BrokerService brokerService;
    private static String BROKER_ADDRESS;
    private String connectionUri;
    private ActiveMQConnectionFactory cf;
    private final String CLIENT_ID = "AMQ4356Test";
    private final String SUBSCRIPTION_NAME = "AMQ4356Test";

    private void createBroker(boolean deleteOnStart) throws Exception {
        brokerService = new BrokerService();
        brokerService.setUseJmx(true);
        brokerService.setDeleteAllMessagesOnStartup(deleteOnStart);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    private void startBroker() throws Exception {
        this.createBroker(true);
    }

    private void restartBroker() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
        this.createBroker(false);
    }

    @Before
    public void setUp() throws Exception {
        this.startBroker();
        this.cf = new ActiveMQConnectionFactory(this.connectionUri);
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void testVirtualTopicUnsubDurable() throws Exception {
        Connection connection = this.cf.createConnection();
        connection.setClientID("AMQ4356Test");
        connection.start();
        ActiveMQQueue queue1 = new ActiveMQQueue(this.getVirtualTopicConsumerName());
        ActiveMQQueue queue2 = new ActiveMQQueue(this.getVirtualTopicConsumerName());
        Session session = connection.createSession(false, 1);
        MessageConsumer c1 = session.createConsumer((Destination)queue1);
        c1.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        MessageConsumer c2 = session.createConsumer((Destination)queue2);
        c2.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        ActiveMQTopic topic = new ActiveMQTopic(this.getVirtualTopicName());
        TopicSubscriber c3 = session.createDurableSubscriber((Topic)topic, "AMQ4356Test");
        Assert.assertEquals((long)1L, (long)brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        c3.close();
        MessageProducer producer = session.createProducer((Destination)topic);
        Assert.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            producer.send((Message)session.createTextMessage("message: " + i));
        }
        Assert.assertEquals((long)0L, (long)brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)1L, (long)brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        session.unsubscribe("AMQ4356Test");
        connection.close();
        Assert.assertEquals((long)0L, (long)brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        this.restartBroker();
        Assert.assertEquals((long)0L, (long)brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
    }

    protected String getVirtualTopicName() {
        return "VirtualTopic.TEST";
    }

    protected String getVirtualTopicConsumerName() {
        return "Consumer.A.VirtualTopic.TEST";
    }

    static {
        BROKER_ADDRESS = "tcp://localhost:0";
    }
}

