/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4472Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4472Test.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLostMessage() {
        Connection connection = null;
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.useJmx=false");
            connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(true, 0);
            Queue test_data_destination = session.createQueue("test" + System.currentTimeMillis());
            MessageConsumer consumer = session.createConsumer((Destination)test_data_destination);
            LOG.info("Consumer 1 connected");
            MessageProducer producer = session.createProducer((Destination)test_data_destination);
            producer.send((Message)session.createTextMessage("Message 1"));
            session.commit();
            producer.send((Message)session.createTextMessage("Message 2"));
            LOG.info("Closing consumer 1...");
            consumer.close();
            consumer = session.createConsumer((Destination)test_data_destination);
            LOG.info("Consumer 2 connected");
            Message message = consumer.receive(10000L);
            if (message != null) {
                LOG.info("Got message 1:", (Object)message);
                Assert.assertEquals((String)"expected message", (Object)"Message 1", (Object)((TextMessage)message).getText());
                session.commit();
            } else {
                LOG.error("Expected message but it never arrived");
            }
            Assert.assertNotNull((Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {}
        }
    }
}

