/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutOfOrderTestCase
extends TestCase {
    private static final Logger log = LoggerFactory.getLogger(OutOfOrderTestCase.class);
    private static final String BROKER_URL = "tcp://localhost:0";
    private static final int PREFETCH = 10;
    private static final String CONNECTION_URL_OPTIONS = "?jms.prefetchPolicy.all=10";
    private static final String DESTINATION = "QUEUE?consumer.exclusive=true";
    private BrokerService brokerService;
    private Session session;
    private Connection connection;
    private String connectionUri;
    private int seq = 0;

    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(true);
        this.brokerService.addConnector(BROKER_URL);
        this.brokerService.deleteAllMessages();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getPublishableConnectString();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri + CONNECTION_URL_OPTIONS);
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
    }

    protected void tearDown() throws Exception {
        try {
            this.session.close();
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.brokerService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrder() throws Exception {
        log.info("Producing messages 0-29 . . .");
        Queue destination = this.session.createQueue(DESTINATION);
        try (MessageProducer messageProducer = this.session.createProducer((Destination)destination);){
            for (int i = 0; i < 30; ++i) {
                TextMessage message = this.session.createTextMessage(OutOfOrderTestCase.createMessageText(i));
                message.setStringProperty("JMSXGroupID", "FOO");
                messageProducer.send((Message)message);
                log.info("sent " + this.toString((Message)message));
            }
        }
        log.info("Consuming messages 0-9 . . .");
        this.consumeBatch();
        log.info("Consuming messages 10-19 . . .");
        this.consumeBatch();
        log.info("Consuming messages 20-29 . . .");
        this.consumeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeBatch() throws Exception {
        Queue destination = this.session.createQueue(DESTINATION);
        try (MessageConsumer messageConsumer = this.session.createConsumer((Destination)destination);){
            for (int i = 0; i < 10; ++i) {
                Message message = messageConsumer.receive(1000L);
                log.info("received " + this.toString(message));
                OutOfOrderTestCase.assertEquals((String)"Message out of order", (String)OutOfOrderTestCase.createMessageText(this.seq++), (String)((TextMessage)message).getText());
                message.acknowledge();
            }
        }
    }

    private String toString(Message message) throws JMSException {
        String ret = "received message '" + ((TextMessage)message).getText() + "' - " + message.getJMSMessageID();
        if (message.getJMSRedelivered()) {
            ret = ret + " (redelivered)";
        }
        return ret;
    }

    private static String createMessageText(int index) {
        return "message #" + index;
    }
}

