/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.bugs.MessageSender;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySteadyEnqueueRate
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(VerifySteadyEnqueueRate.class);
    private static int max_messages = 1000000;
    private final String destinationName = this.getName() + "_Queue";
    private BrokerService broker;
    final boolean useTopic = false;
    protected static final String payload = new String(new byte[24]);

    public void setUp() throws Exception {
        this.startBroker();
    }

    public void tearDown() throws Exception {
        this.broker.stop();
    }

    public void testEnqueueRateCanMeetSLA() throws Exception {
    }

    private void doTestEnqueue(final boolean transacted) throws Exception {
        long min = 100L;
        final AtomicLong total = new AtomicLong(0L);
        final AtomicLong slaViolations = new AtomicLong(0L);
        final AtomicLong max = new AtomicLong(0L);
        int numThreads = 6;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    MessageSender producer = new MessageSender(VerifySteadyEnqueueRate.this.destinationName, VerifySteadyEnqueueRate.this.createConnection(), transacted, false);
                    for (int i = 0; i < max_messages; ++i) {
                        long startT = System.currentTimeMillis();
                        producer.send(payload);
                        long endT = System.currentTimeMillis();
                        long duration = endT - startT;
                        total.incrementAndGet();
                        if (duration > max.get()) {
                            max.set(duration);
                        }
                        if (duration <= 100L) continue;
                        slaViolations.incrementAndGet();
                        System.err.println("SLA violation @ " + Thread.currentThread().getName() + " " + DateFormat.getTimeInstance().format(new Date(startT)) + " at message " + i + " send time=" + duration + " - Total SLA violations: " + slaViolations.get() + "/" + total.get() + " (" + String.format("%.6f", 100.0 * (double)slaViolations.get() / (double)total.get()) + "%)");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("Max Violation = " + max + " - Total SLA violations: " + slaViolations.get() + "/" + total.get() + " (" + String.format("%.6f", 100.0 * (double)slaViolations.get() / (double)total.get()) + "%)");
            }
        };
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < 6; ++i) {
            executor.execute(runner);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    private Connection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri());
        return factory.createConnection();
    }

    private void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        kaha.setEnableJournalDiskSyncs(false);
        kaha.setJournalMaxFileLength(0x6400000);
        kaha.setIndexWriteBatchSize(100);
        kaha.setEnableIndexWriteAsync(true);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        this.broker.addConnector("tcp://localhost:0").setName("Default");
        this.broker.start();
        LOG.info("Starting broker..");
    }
}

