/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.demo;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleQueueSender {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleQueueSender.class);

    private SimpleQueueSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String queueName = null;
        InitialContext jndiContext = null;
        QueueConnectionFactory queueConnectionFactory = null;
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        Queue queue = null;
        QueueSender queueSender = null;
        TextMessage message = null;
        if (args.length < 1 || args.length > 2) {
            LOG.info("Usage: java SimpleQueueSender <queue-name> [<number-of-messages>]");
            System.exit(1);
        }
        queueName = args[0];
        LOG.info("Queue name is " + queueName);
        int numMsgs = args.length == 2 ? Integer.valueOf(args[1]) : 1;
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            LOG.info("Could not create JNDI API context: " + e.toString());
            System.exit(1);
        }
        try {
            queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup("QueueConnectionFactory");
            queue = (Queue)jndiContext.lookup(queueName);
        }
        catch (NamingException e) {
            LOG.info("JNDI API lookup failed: " + e);
            System.exit(1);
        }
        try {
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            queueSender = queueSession.createSender(queue);
            message = queueSession.createTextMessage();
            for (int i = 0; i < numMsgs; ++i) {
                message.setText("This is message " + (i + 1));
                LOG.info("Sending message: " + message.getText());
                queueSender.send((Message)message);
            }
            queueSender.send(queueSession.createMessage());
        }
        catch (JMSException e) {
            LOG.info("Exception occurred: " + e.toString());
        }
        finally {
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

