/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.apache.activemq.jms2.ActiveMQJMS2TestSupport;
import org.apache.activemq.jms2.MessageData;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQJMS2MessageTypesTest
extends ActiveMQJMS2TestBase {
    private final Set<Integer> VALID_PRIORITIES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9));
    private final String clientID;
    private final String destinationType;
    private final String messagePayload;
    private final String messageType;

    public ActiveMQJMS2MessageTypesTest(String destinationType, String messageType) {
        this.clientID = destinationType + "-" + messageType;
        this.destinationType = destinationType;
        this.messagePayload = "Test message payload";
        this.messageType = messageType;
    }

    @Parameterized.Parameters(name="destinationType={0}, messageType={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"queue", "bytes"}, {"queue", "map"}, {"queue", "object"}, {"queue", "stream"}, {"queue", "text"}, {"topic", "bytes"}, {"topic", "map"}, {"topic", "object"}, {"topic", "stream"}, {"topic", "text"}, {"temp-queue", "bytes"}, {"temp-queue", "map"}, {"temp-queue", "object"}, {"temp-queue", "stream"}, {"temp-queue", "text"}, {"temp-topic", "bytes"}, {"temp-topic", "map"}, {"temp-topic", "object"}, {"temp-topic", "stream"}, {"temp-topic", "text"});
    }

    @Test
    public void testMessageDeliveryMode() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            for (int deliveryMode : Arrays.asList(1, 2)) {
                MessageData sendMessageData = new MessageData();
                sendMessageData.setMessage(message).setDeliveryMode(deliveryMode);
                sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            }
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final AtomicBoolean receivedExpected = new AtomicBoolean(false);
            final AtomicInteger exceptionCount = new AtomicInteger();
            jmsConsumer.setMessageListener(new MessageListener(){
                private boolean recvNonPersistent = false;
                private boolean recvPersistent = false;

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    try {
                        switch (message.getJMSDeliveryMode()) {
                            case 1: {
                                this.recvNonPersistent = true;
                                break;
                            }
                            case 2: {
                                this.recvPersistent = true;
                                break;
                            }
                        }
                        if (this.recvNonPersistent && this.recvPersistent) {
                            receivedExpected.set(true);
                        }
                    }
                    catch (JMSException e) {
                        exceptionCount.incrementAndGet();
                    }
                }
            });
            jmsContext.start();
            Assert.assertTrue((String)"Expected to receive both DeliveryModes", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return receivedExpected.get();
                }
            }, (long)5000L, (long)100L));
            jmsConsumer.close();
            jmsContext.stop();
            Assert.assertEquals((Object)2, (Object)recvMessages.size());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessageDeliveryModeInvalid() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            jmsContext.start();
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            MessageData sendMessageData = new MessageData();
            sendMessageData.setMessage(message).setDeliveryMode(99);
            boolean caught = false;
            try {
                ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData);
                Assert.fail((String)"IlegalStateRuntimeException expected");
            }
            catch (IllegalStateRuntimeException e) {
                Assert.assertEquals((Object)"unknown delivery mode: 99", (Object)e.getMessage());
                caught = true;
            }
            Assert.assertTrue((boolean)caught);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessagePriority() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            for (int priority : this.VALID_PRIORITIES) {
                MessageData sendMessageData = new MessageData();
                sendMessageData.setMessage(message).setPriority(priority);
                sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            }
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(10);
            jmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            jmsContext.start();
            Assert.assertTrue((String)"Expected to receive 10 messages", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumer.close();
            jmsContext.stop();
            Assert.assertEquals((Object)10, (Object)recvMessages.size());
            int validatedCount = 0;
            for (int validatedPriority : this.VALID_PRIORITIES) {
                for (Message tmpMessage : recvMessages) {
                    if (tmpMessage.getJMSPriority() != validatedPriority) continue;
                    MessageData messageData = new MessageData();
                    messageData.setMessageType(this.messageType).setMessagePayload(this.messagePayload).setPriority(validatedPriority);
                    ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, messageData);
                    ++validatedCount;
                }
            }
            Assert.assertEquals((Object)10, (Object)validatedCount);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessagePriorityInvalidLower() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            MessageData sendMessageData = new MessageData();
            sendMessageData.setMessage(message).setPriority(-1);
            boolean caught = false;
            try {
                ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData);
                Assert.fail((String)"IlegalStateRuntimeException expected");
            }
            catch (IllegalStateRuntimeException e) {
                Assert.assertEquals((Object)"default priority must be a value between 0 and 9", (Object)e.getMessage());
                caught = true;
            }
            Assert.assertTrue((boolean)caught);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessagePriorityInvalidHigher() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            MessageData sendMessageData = new MessageData();
            sendMessageData.setMessage(message).setPriority(10);
            boolean caught = false;
            try {
                ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData);
                Assert.fail((String)"IlegalStateRuntimeException expected");
            }
            catch (IllegalStateRuntimeException e) {
                Assert.assertEquals((Object)"default priority must be a value between 0 and 9", (Object)e.getMessage());
                caught = true;
            }
            Assert.assertTrue((boolean)caught);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessageTimestampTimeToLive() {
        long timeToLive = 900000L;
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            long messageExpiration = Long.MIN_VALUE;
            long messageTimestamp = Long.MIN_VALUE;
            MessageData sendMessageData = new MessageData();
            sendMessageData.setMessage(message).setTimeToLive(timeToLive);
            sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            messageExpiration = message.getJMSExpiration();
            messageTimestamp = message.getJMSTimestamp();
            Assert.assertNotEquals((long)Long.MIN_VALUE, (long)messageExpiration);
            Assert.assertNotEquals((long)Long.MIN_VALUE, (long)messageTimestamp);
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            jmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            jmsContext.start();
            Assert.assertTrue((String)"Expected to receive 1 message", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumer.close();
            jmsContext.stop();
            Assert.assertEquals((Object)1, (Object)recvMessages.size());
            int validatedCount = 0;
            for (Message tmpMessage : recvMessages) {
                MessageData recvMessageData = new MessageData();
                recvMessageData.setMessageType(this.messageType).setMessagePayload(this.messagePayload).setExpiration(messageExpiration).setTimestamp(messageTimestamp);
                ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, recvMessageData);
                ++validatedCount;
            }
            Assert.assertEquals((Object)1, (Object)validatedCount);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessageDisableTimestamp() {
        long timeToLive = 900000L;
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            long messageExpiration = Long.MIN_VALUE;
            long messageTimestamp = Long.MIN_VALUE;
            MessageData sendMessageData = new MessageData();
            sendMessageData.setMessage(message).setTimeToLive(timeToLive).setDisableMessageTimestamp(true);
            sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            messageExpiration = message.getJMSExpiration();
            messageTimestamp = message.getJMSTimestamp();
            Assert.assertEquals((long)0L, (long)messageTimestamp);
            Assert.assertNotEquals((long)Long.MIN_VALUE, (long)messageExpiration);
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            jmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            jmsContext.start();
            Assert.assertTrue((String)"Expected to receive 1 message", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumer.close();
            jmsContext.stop();
            for (Message tmpMessage : recvMessages) {
                MessageData recvMessageData = new MessageData();
                recvMessageData.setMessagePayload(this.messagePayload).setMessageType(this.messageType).setExpiration(messageExpiration).setTimestamp(messageTimestamp).setDisableMessageTimestamp(true);
                ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, recvMessageData);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessageNonQOSHeaders() {
        String jmsCorrelationID = UUID.randomUUID().toString();
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            Destination jmsReplyTo = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName + ".REPLYTO");
            String jmsType = message.getClass().getName();
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            MessageData sendMessageData = new MessageData();
            sendMessageData.setMessage(message).setCorrelationID(jmsCorrelationID).setReplyTo(jmsReplyTo).setJMSType(jmsType);
            sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            jmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            jmsContext.start();
            Assert.assertTrue((String)"Expected to receive 1 message", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumer.close();
            jmsContext.stop();
            for (Message tmpMessage : recvMessages) {
                MessageData recvMessageData = new MessageData();
                recvMessageData.setMessagePayload(this.messagePayload).setMessageType(this.messageType).setCorrelationID(jmsCorrelationID).setReplyTo(jmsReplyTo).setJMSType(jmsType);
                ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, recvMessageData);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMessageDisableMessageID() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            String jmsMessageID = ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, message);
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            jmsConsumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            jmsContext.start();
            Assert.assertTrue((String)"Expected to receive 1 message", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumer.close();
            jmsContext.stop();
            for (Message tmpMessage : recvMessages) {
                MessageData messageData = new MessageData();
                messageData.setMessageType(this.messageType).setMessagePayload(this.messagePayload).setMessageID(jmsMessageID);
                ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, messageData);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopicDurableSubscriber() {
        if (!"topic".equals(this.destinationType)) {
            return;
        }
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setClientID(this.clientID);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            Assert.assertTrue((boolean)(destination instanceof Topic));
            Topic topic = (Topic)Topic.class.cast(destination);
            JMSConsumer jmsConsumerRegister = jmsContext.createDurableConsumer(topic, this.methodNameDestinationName);
            Assert.assertNotNull((Object)jmsConsumerRegister);
            jmsContext.start();
            jmsConsumerRegister.close();
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            String jmsMessageID = ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, message);
            JMSConsumer jmsConsumerDurable = jmsContext.createDurableConsumer(topic, this.methodNameDestinationName);
            Assert.assertNotNull((Object)jmsConsumerDurable);
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            jmsConsumerDurable.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            Assert.assertTrue((String)"Expected to receive 1 message", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumerDurable.close();
            jmsContext.stop();
            for (Message tmpMessage : recvMessages) {
                MessageData messageData = new MessageData();
                messageData.setMessageType(this.messageType).setMessagePayload(this.messagePayload).setMessageID(jmsMessageID);
                ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, messageData);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTopicDurableSubscriberSelector() {
        if (!"topic".equals(this.destinationType)) {
            return;
        }
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", 1);){
            Assert.assertNotNull((Object)jmsContext);
            jmsContext.setClientID(this.clientID);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.methodNameDestinationName);
            Assert.assertNotNull((Object)destination);
            Assert.assertTrue((boolean)(destination instanceof Topic));
            Topic topic = (Topic)Topic.class.cast(destination);
            JMSConsumer jmsConsumerRegister = jmsContext.createDurableConsumer(topic, this.methodNameDestinationName, "JMSPriority=7", false);
            Assert.assertNotNull((Object)jmsConsumerRegister);
            Assert.assertEquals((Object)"JMSPriority=7", (Object)jmsConsumerRegister.getMessageSelector());
            jmsContext.start();
            jmsConsumerRegister.close();
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, this.messageType, this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            String matchMessageId = null;
            for (int priority = 0; priority < 10; ++priority) {
                MessageData sendMessageData = new MessageData();
                sendMessageData.setMessage(message).setPriority(priority);
                String sentMessageId = ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData);
                sentMessageIds.add(sentMessageId);
                if (priority != 7) continue;
                matchMessageId = sentMessageId;
            }
            JMSConsumer jmsConsumerDurable = jmsContext.createDurableConsumer(topic, this.methodNameDestinationName, "JMSPriority=7", false);
            Assert.assertNotNull((Object)jmsConsumerDurable);
            Assert.assertEquals((Object)"JMSPriority=7", (Object)jmsConsumerDurable.getMessageSelector());
            final CopyOnWriteArrayList recvMessages = new CopyOnWriteArrayList();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            jmsConsumerDurable.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    recvMessages.add(message);
                    countDownLatch.countDown();
                }
            });
            Assert.assertTrue((String)"Expected to receive 1 message", (boolean)countDownLatch.await(5L, TimeUnit.SECONDS));
            jmsConsumerDurable.close();
            jmsContext.stop();
            for (Message tmpMessage : recvMessages) {
                MessageData recvMessageData = new MessageData();
                recvMessageData.setMessageType(this.messageType).setMessagePayload(this.messagePayload).setMessageID(matchMessageId);
                ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, recvMessageData);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

