/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBeanSecurityWithGuestNoCredentialsOnlyTest
extends JmsTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(XBeanSecurityWithGuestNoCredentialsOnlyTest.class);
    public ActiveMQDestination destination;

    public static Test suite() {
        return XBeanSecurityWithGuestNoCredentialsOnlyTest.suite(XBeanSecurityWithGuestNoCredentialsOnlyTest.class);
    }

    public void testUserSendGoodPassword() throws JMSException {
        Message m = this.doSend(false);
        XBeanSecurityWithGuestNoCredentialsOnlyTest.assertEquals((String)"system", (String)((ActiveMQMessage)m).getUserID());
        XBeanSecurityWithGuestNoCredentialsOnlyTest.assertEquals((String)"system", (String)m.getStringProperty("JMSXUserID"));
    }

    public void testUserSendWrongPassword() throws JMSException {
        try {
            this.doSend(true);
            XBeanSecurityWithGuestNoCredentialsOnlyTest.fail((String)"expect exception on connect");
        }
        catch (JMSException expected) {
            XBeanSecurityWithGuestNoCredentialsOnlyTest.assertTrue((String)"cause as expected", (boolean)(expected.getCause() instanceof SecurityException));
        }
    }

    public void testUserSendNoCredentials() throws JMSException {
        Message m = this.doSend(false);
        XBeanSecurityWithGuestNoCredentialsOnlyTest.assertEquals((String)"guest", (String)((ActiveMQMessage)m).getUserID());
        XBeanSecurityWithGuestNoCredentialsOnlyTest.assertEquals((String)"guest", (String)m.getStringProperty("JMSXUserID"));
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/jaas-broker-guest-no-creds-only.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    public Message doSend(boolean fail) throws JMSException {
        MessageConsumer consumer;
        block4: {
            Connection adminConnection = this.factory.createConnection("system", "manager");
            this.connections.add(adminConnection);
            adminConnection.start();
            Session adminSession = adminConnection.createSession(false, 1);
            consumer = adminSession.createConsumer((Destination)this.destination);
            this.connections.remove(this.connection);
            this.connection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
            this.connections.add(this.connection);
            Session session = this.connection.createSession(false, 1);
            try {
                this.sendMessages(session, (Destination)this.destination, 1);
            }
            catch (JMSException e) {
                if (fail && e.getCause() instanceof SecurityException) break block4;
                throw e;
            }
        }
        Message m = consumer.receive(1000L);
        if (fail) {
            XBeanSecurityWithGuestNoCredentialsOnlyTest.assertNull((Object)m);
        } else {
            XBeanSecurityWithGuestNoCredentialsOnlyTest.assertNotNull((Object)m);
            XBeanSecurityWithGuestNoCredentialsOnlyTest.assertEquals((String)"0", (String)((TextMessage)m).getText());
            XBeanSecurityWithGuestNoCredentialsOnlyTest.assertNull((Object)consumer.receiveNoWait());
        }
        return m;
    }

    public void initCombosForTestUserSendGoodPassword() {
        this.addCombinationValues("userName", new Object[]{"system"});
        this.addCombinationValues("password", new Object[]{"manager"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("test"), new ActiveMQTopic("test")});
    }

    public void initCombosForTestUserSendWrongPassword() {
        this.addCombinationValues("userName", new Object[]{"system"});
        this.addCombinationValues("password", new Object[]{"wrongpassword"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("GuestQueue")});
    }

    public void initCombosForTestUserSendNoCredentials() {
        this.addCombinationValues("userName", new Object[]{null, "system"});
        this.addCombinationValues("password", new Object[]{null});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("GuestQueue")});
    }
}

