/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerBean
extends Assert
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerBean.class);
    private final List<Message> messages = new ArrayList<Message>();
    private boolean verbose;
    private String id = null;

    public ConsumerBean() {
    }

    public ConsumerBean(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> flushMessages() {
        ArrayList<Message> answer = null;
        List<Message> list = this.messages;
        synchronized (list) {
            answer = new ArrayList<Message>(this.messages);
            this.messages.clear();
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        List<Message> list = this.messages;
        synchronized (list) {
            this.messages.add(message);
            if (this.verbose) {
                LOG.info(this.id + "Received: " + message);
            }
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessageToArrive() {
        long start;
        block5: {
            LOG.info("Waiting for message to arrive");
            start = System.currentTimeMillis();
            try {
                if (!this.hasReceivedMessage()) break block5;
                List<Message> list = this.messages;
                synchronized (list) {
                    this.messages.wait(4000L);
                }
            }
            catch (InterruptedException e) {
                LOG.info("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        LOG.info("End of wait for " + end + " millis");
    }

    public void waitForMessagesToArrive(int messageCount) {
        this.waitForMessagesToArrive(messageCount, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount, long maxWaitTime) {
        long maxRemainingMessageCount = Math.max(0, messageCount - this.messages.size());
        LOG.info("Waiting for (" + maxRemainingMessageCount + ") message(s) to arrive");
        long start = System.currentTimeMillis();
        long endTime = start + maxWaitTime;
        while (maxRemainingMessageCount > 0L) {
            try {
                List<Message> list = this.messages;
                synchronized (list) {
                    this.messages.wait(1000L);
                }
                if (this.hasReceivedMessages(messageCount) || System.currentTimeMillis() > endTime) {
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.info("Caught: " + e);
            }
            maxRemainingMessageCount = Math.max(0, messageCount - this.messages.size());
        }
        long end = System.currentTimeMillis() - start;
        LOG.info("End of wait for " + end + " millis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertMessagesArrived(int total) {
        this.waitForMessagesToArrive(total);
        List<Message> list = this.messages;
        synchronized (list) {
            int count = this.messages.size();
            ConsumerBean.assertEquals((String)"Messages received", (long)total, (long)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertMessagesArrived(int total, long maxWaitTime) {
        this.waitForMessagesToArrive(total, maxWaitTime);
        List<Message> list = this.messages;
        synchronized (list) {
            int count = this.messages.size();
            ConsumerBean.assertEquals((String)"Messages received", (long)total, (long)count);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    protected boolean hasReceivedMessage() {
        return this.messages.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasReceivedMessages(int messageCount) {
        List<Message> list = this.messages;
        synchronized (list) {
            return this.messages.size() >= messageCount;
        }
    }
}

