/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;

public class KahaDBTest
extends TestCase {
    protected BrokerService createBroker(KahaDBStore kaha) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(false);
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        broker.start();
        return broker;
    }

    private KahaDBStore createStore(boolean delete) throws IOException {
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/kahadb"));
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    public void testIgnoreMissingJournalfilesOptionSetFalse() throws Exception {
        KahaDBStore kaha = this.createStore(true);
        kaha.setJournalMaxFileLength(102400);
        KahaDBTest.assertFalse((boolean)kaha.isIgnoreMissingJournalfiles());
        BrokerService broker = this.createBroker(kaha);
        this.sendMessages(1000);
        broker.stop();
        this.assertExistsAndDelete(new File(kaha.getDirectory(), "db-4.log"));
        this.assertExistsAndDelete(new File(kaha.getDirectory(), "db-8.log"));
        kaha = this.createStore(false);
        kaha.setJournalMaxFileLength(102400);
        KahaDBTest.assertFalse((boolean)kaha.isIgnoreMissingJournalfiles());
        try {
            broker = this.createBroker(kaha);
            KahaDBTest.fail((String)"expected IOException");
        }
        catch (IOException e) {
            KahaDBTest.assertTrue((boolean)e.getMessage().startsWith("Detected missing/corrupt journal files"));
        }
    }

    public void testIgnoreMissingJournalfilesOptionSetTrue() throws Exception {
        KahaDBStore kaha = this.createStore(true);
        kaha.setJournalMaxFileLength(102400);
        KahaDBTest.assertFalse((boolean)kaha.isIgnoreMissingJournalfiles());
        BrokerService broker = this.createBroker(kaha);
        this.sendMessages(1000);
        broker.stop();
        this.assertExistsAndDelete(new File(kaha.getDirectory(), "db-4.log"));
        this.assertExistsAndDelete(new File(kaha.getDirectory(), "db-8.log"));
        kaha = this.createStore(false);
        kaha.setIgnoreMissingJournalfiles(true);
        kaha.setJournalMaxFileLength(102400);
        broker = this.createBroker(kaha);
        int count = this.receiveMessages();
        KahaDBTest.assertTrue((count > 800 ? 1 : 0) != 0);
        KahaDBTest.assertTrue((count < 1000 ? 1 : 0) != 0);
        broker.stop();
    }

    public void testCheckCorruptionNotIgnored() throws Exception {
        KahaDBStore kaha = this.createStore(true);
        KahaDBTest.assertTrue((boolean)kaha.isChecksumJournalFiles());
        KahaDBTest.assertFalse((boolean)kaha.isCheckForCorruptJournalFiles());
        kaha.setJournalMaxFileLength(102400);
        kaha.setChecksumJournalFiles(true);
        BrokerService broker = this.createBroker(kaha);
        this.sendMessages(1000);
        broker.stop();
        this.assertExistsAndCorrupt(new File(kaha.getDirectory(), "db-4.log"));
        this.assertExistsAndCorrupt(new File(kaha.getDirectory(), "db-8.log"));
        kaha = this.createStore(false);
        kaha.setJournalMaxFileLength(102400);
        kaha.setChecksumJournalFiles(true);
        kaha.setCheckForCorruptJournalFiles(true);
        KahaDBTest.assertFalse((boolean)kaha.isIgnoreMissingJournalfiles());
        try {
            broker = this.createBroker(kaha);
            KahaDBTest.fail((String)"expected IOException");
        }
        catch (IOException e) {
            KahaDBTest.assertTrue((boolean)e.getMessage().startsWith("Detected missing/corrupt journal files"));
        }
    }

    public void testMigrationOnNewDefaultForChecksumJournalFiles() throws Exception {
        KahaDBStore kaha = this.createStore(true);
        kaha.setChecksumJournalFiles(false);
        KahaDBTest.assertFalse((boolean)kaha.isChecksumJournalFiles());
        KahaDBTest.assertFalse((boolean)kaha.isCheckForCorruptJournalFiles());
        kaha.setJournalMaxFileLength(102400);
        BrokerService broker = this.createBroker(kaha);
        this.sendMessages(1000);
        broker.stop();
        kaha = this.createStore(false);
        kaha.setJournalMaxFileLength(102400);
        kaha.setCheckForCorruptJournalFiles(true);
        KahaDBTest.assertFalse((boolean)kaha.isIgnoreMissingJournalfiles());
        this.createBroker(kaha);
        KahaDBTest.assertEquals((int)1000, (int)this.receiveMessages());
    }

    private void assertExistsAndCorrupt(File file) throws IOException {
        KahaDBTest.assertTrue((boolean)file.exists());
        try (RandomAccessFile f = new RandomAccessFile(file, "rw");){
            f.seek(5254L);
            f.write("... corruption string ...".getBytes());
        }
    }

    public void testCheckCorruptionIgnored() throws Exception {
        KahaDBStore kaha = this.createStore(true);
        kaha.setJournalMaxFileLength(102400);
        BrokerService broker = this.createBroker(kaha);
        this.sendMessages(1000);
        broker.stop();
        this.assertExistsAndCorrupt(new File(kaha.getDirectory(), "db-4.log"));
        this.assertExistsAndCorrupt(new File(kaha.getDirectory(), "db-8.log"));
        kaha = this.createStore(false);
        kaha.setIgnoreMissingJournalfiles(true);
        kaha.setJournalMaxFileLength(102400);
        kaha.setCheckForCorruptJournalFiles(true);
        broker = this.createBroker(kaha);
        int count = this.receiveMessages();
        KahaDBTest.assertTrue((String)("Expected to received a min # of messages.. Got: " + count), (count > 990 ? 1 : 0) != 0);
        KahaDBTest.assertTrue((count < 1000 ? 1 : 0) != 0);
        broker.stop();
    }

    public void testNoReplayOnStopStart() throws Exception {
        KahaDBStore kaha = this.createStore(true);
        BrokerService broker = this.createBroker(kaha);
        this.sendMessages(100);
        broker.stop();
        broker.waitUntilStopped();
        kaha = this.createStore(false);
        kaha.setCheckForCorruptJournalFiles(true);
        final AtomicBoolean didSomeRecovery = new AtomicBoolean(false);
        Logger logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (Level.INFO.equals((Object)event.getLevel()) && event.getMessage().getFormattedMessage().contains("Recovering from the journal @")) {
                    didSomeRecovery.set(true);
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        broker = this.createBroker(kaha);
        int count = this.receiveMessages();
        KahaDBTest.assertEquals((String)"Expected to received all messages.", (int)count, (int)100);
        broker.stop();
        logger.removeAppender((Appender)appender);
        KahaDBTest.assertFalse((String)"Did not replay any records from the journal", (boolean)didSomeRecovery.get());
    }

    private void assertExistsAndDelete(File file) {
        KahaDBTest.assertTrue((boolean)file.exists());
        file.delete();
        KahaDBTest.assertFalse((boolean)file.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages(int count) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue("TEST"));
            for (int i = 0; i < count; ++i) {
                producer.send((Message)session.createTextMessage(this.createContent(i)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveMessages() throws JMSException {
        int rc = 0;
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        try (Connection connection = cf.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            MessageConsumer messageConsumer = session.createConsumer((Destination)new ActiveMQQueue("TEST"));
            while (messageConsumer.receive(1000L) != null) {
                ++rc;
            }
            int n = rc;
            return n;
        }
    }

    private String createContent(int i) {
        StringBuilder sb = new StringBuilder(i + ":");
        while (sb.length() < 1024) {
            sb.append("*");
        }
        return sb.toString();
    }
}

