/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.activemq.test.JmsSendReceiveTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTopicSendReceiveTest
extends JmsSendReceiveTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsTopicSendReceiveTest.class);
    protected Connection connection;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        LOG.info("Created connection: " + this.connection);
        this.session = this.connection.createSession(false, 1);
        this.consumeSession = this.createConsumerSession();
        LOG.info("Created session: " + this.session);
        LOG.info("Created consumeSession: " + this.consumeSession);
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        LOG.info("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        LOG.info("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        LOG.info("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener((MessageListener)this);
        this.startConnection();
        LOG.info("Created connection: " + this.connection);
    }

    protected void startConnection() throws JMSException {
        this.connection.start();
    }

    protected void tearDown() throws Exception {
        LOG.info("Closing down connection");
        this.session.close();
        this.connection.close();
    }

    protected Session createConsumerSession() throws JMSException {
        if (this.useSeparateSession) {
            return this.connection.createSession(false, 1);
        }
        return this.session;
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            LOG.info("Creating durable consumer");
            return this.consumeSession.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.consumeSession.createConsumer(this.consumerDestination);
    }
}

