/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import jakarta.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.Test;

public class TransportConnectorInvalidSocketOptionsTest
extends TestCase {
    @Test
    public void testClientParameters() throws Exception {
        try {
            new ActiveMQConnectionFactory("tcp://localhost:42?foo=bar").createConnection();
            TransportConnectorInvalidSocketOptionsTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            TransportConnectorInvalidSocketOptionsTest.assertEquals(JMSException.class, e.getClass());
            TransportConnectorInvalidSocketOptionsTest.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
            TransportConnectorInvalidSocketOptionsTest.assertEquals((String)"Invalid connect parameters: {foo=bar}", (String)e.getCause().getMessage());
        }
    }

    @Test
    public void testClientSocketParameters() throws Exception {
        BrokerService broker = null;
        try {
            broker = new BrokerService();
            broker.setPersistent(false);
            broker.addConnector("tcp://localhost:61616");
            broker.start();
            try {
                new ActiveMQConnectionFactory("tcp://localhost:61616?socket.foo=bar").createConnection();
                TransportConnectorInvalidSocketOptionsTest.fail((String)"Should have thrown an exception");
            }
            catch (Exception e) {
                TransportConnectorInvalidSocketOptionsTest.assertEquals(JMSException.class, e.getClass());
                TransportConnectorInvalidSocketOptionsTest.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
                TransportConnectorInvalidSocketOptionsTest.assertEquals((String)"Invalid socket parameters: {foo=bar}", (String)e.getCause().getMessage());
            }
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }
}

