/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.activemq.TestSupport;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestBase;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DurableSubscriptionOffline3Test
extends DurableSubscriptionOfflineTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionOffline3Test.class);
    private static String filter = "$a='A1' AND (($b=true AND $c=true) OR ($d='D1' OR $d='D2'))";

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestSupport.PersistenceAdapterChoice[]> getTestParameters() {
        String osName = System.getProperty("os.name");
        LOG.debug("Running on [" + osName + "]");
        TestSupport.PersistenceAdapterChoice[] kahaDb = new TestSupport.PersistenceAdapterChoice[]{TestSupport.PersistenceAdapterChoice.KahaDB};
        TestSupport.PersistenceAdapterChoice[] jdbc = new TestSupport.PersistenceAdapterChoice[]{TestSupport.PersistenceAdapterChoice.JDBC};
        ArrayList<TestSupport.PersistenceAdapterChoice[]> choices = new ArrayList<TestSupport.PersistenceAdapterChoice[]>();
        choices.add(kahaDb);
        choices.add(jdbc);
        return choices;
    }

    public DurableSubscriptionOffline3Test(TestSupport.PersistenceAdapterChoice persistenceAdapterChoice) {
        this.defaultPersistenceAdapter = persistenceAdapterChoice;
        LOG.info(">>>> running {} with persistenceAdapterChoice: {}", (Object)this.testName.getMethodName(), (Object)this.defaultPersistenceAdapter);
    }

    @Test(timeout=60000L)
    public void testInterleavedOfflineSubscriptionCanConsume() throws Exception {
        Connection con = this.createConnection("cliId1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        Connection con2 = this.createConnection("cliId2");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener2 = new DurableSubscriptionOfflineTestListener();
        consumer2.setMessageListener((MessageListener)listener2);
        Assert.assertEquals((long)0L, (long)listener2.count);
        session2.close();
        con2.close();
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        con2 = this.createConnection("cliId2");
        session2 = con2.createSession(false, 1);
        consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        listener2 = new DurableSubscriptionOfflineTestListener("cliId2");
        consumer2.setMessageListener((MessageListener)listener2);
        Thread.sleep(3000L);
        Assert.assertEquals((long)10L, (long)listener2.count);
        con = this.createConnection("cliId1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener("cliId1");
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        Assert.assertEquals((String)"offline consumer got all", (long)sent, (long)listener.count);
    }

    @Test(timeout=60000L)
    public void testMixOfOnLineAndOfflineSubsGetAllMatched() throws Exception {
        Connection con = this.createConnection("offCli1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        session.close();
        con.close();
        con = this.createConnection("offCli2");
        session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        session.close();
        con.close();
        Connection con2 = this.createConnection("onlineCli1");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        DurableSubscriptionOfflineTestListener listener2 = new DurableSubscriptionOfflineTestListener();
        consumer2.setMessageListener((MessageListener)listener2);
        Connection con4 = this.createConnection("nondurableCli");
        Session session4 = con4.createSession(false, 1);
        MessageConsumer consumer4 = session4.createConsumer((Destination)this.topic, filter, true);
        DurableSubscriptionOfflineTestListener listener4 = new DurableSubscriptionOfflineTestListener();
        consumer4.setMessageListener((MessageListener)listener4);
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        boolean hasRelevant = false;
        int filtered = 0;
        for (int i = 0; i < 100; ++i) {
            int postf = (int)(Math.random() * 9.0) + 1;
            String d = "D" + postf;
            if ("D1".equals(d) || "D2".equals(d)) {
                hasRelevant = true;
                ++filtered;
            }
            Message message = session.createMessage();
            message.setStringProperty("$a", "A1");
            message.setStringProperty("$d", d);
            producer.send((Destination)this.topic, message);
        }
        Message message = session.createMessage();
        message.setStringProperty("$a", "A1");
        message.setBooleanProperty("$b", true);
        message.setBooleanProperty("$c", hasRelevant);
        producer.send((Destination)this.topic, message);
        if (hasRelevant) {
            ++filtered;
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        Thread.sleep(3000L);
        session4.close();
        con4.close();
        Assert.assertEquals((long)filtered, (long)listener4.count);
        session2.close();
        con2.close();
        Assert.assertEquals((long)filtered, (long)listener2.count);
        con = this.createConnection("offCli1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        FilterCheckListener listener = new FilterCheckListener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        Assert.assertEquals((long)filtered, (long)listener.count);
        Connection con3 = this.createConnection("offCli2");
        Session session3 = con3.createSession(false, 1);
        TopicSubscriber consumer3 = session3.createDurableSubscriber((Topic)this.topic, "SubsId", filter, true);
        FilterCheckListener listener3 = new FilterCheckListener();
        consumer3.setMessageListener((MessageListener)listener3);
        Thread.sleep(3000L);
        session3.close();
        con3.close();
        Assert.assertEquals((long)filtered, (long)listener3.count);
        Assert.assertTrue((String)("no unexpected exceptions: " + this.exceptions), (boolean)this.exceptions.isEmpty());
    }

    @Test(timeout=60000L)
    public void testOfflineSubscriptionWithSelectorAfterRestart() throws Exception {
        Message message;
        boolean filter;
        int i;
        Connection con = this.createConnection("offCli1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection("offCli2");
        session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int filtered = 0;
        for (i = 0; i < 10; ++i) {
            boolean bl = filter = (int)(Math.random() * 2.0) >= 1;
            if (filter) {
                ++filtered;
            }
            message = session.createMessage();
            message.setStringProperty("filter", filter ? "true" : "false");
            producer.send((Destination)this.topic, message);
        }
        LOG.info("sent: " + filtered);
        Thread.sleep(1000L);
        session.close();
        con.close();
        Thread.sleep(3000L);
        this.broker.stop();
        this.createBroker(false);
        con = this.createConnection();
        session = con.createSession(false, 1);
        producer = session.createProducer(null);
        for (i = 0; i < 10; ++i) {
            boolean bl = filter = (int)(Math.random() * 2.0) >= 1;
            if (filter) {
                ++filtered;
            }
            message = session.createMessage();
            message.setStringProperty("filter", filter ? "true" : "false");
            producer.send((Destination)this.topic, message);
        }
        LOG.info("after restart, total sent with filter='true': " + filtered);
        Thread.sleep(1000L);
        session.close();
        con.close();
        con = this.createConnection("offCli1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener("1>");
        consumer.setMessageListener((MessageListener)listener);
        Connection con3 = this.createConnection("offCli2");
        Session session3 = con3.createSession(false, 1);
        TopicSubscriber consumer3 = session3.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener3 = new DurableSubscriptionOfflineTestListener();
        consumer3.setMessageListener((MessageListener)listener3);
        Thread.sleep(3000L);
        session.close();
        con.close();
        session3.close();
        con3.close();
        Assert.assertEquals((long)filtered, (long)listener.count);
        Assert.assertEquals((long)filtered, (long)listener3.count);
    }

    @Test(timeout=60000L)
    public void testOfflineSubscriptionAfterRestart() throws Exception {
        Message message;
        int i;
        Connection con = this.createConnection("offCli1");
        Session session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", null, false);
        DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener();
        consumer.setMessageListener((MessageListener)listener);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (i = 0; i < 10; ++i) {
            ++sent;
            message = session.createMessage();
            message.setStringProperty("filter", "false");
            producer.send((Destination)this.topic, message);
        }
        LOG.info("sent: " + sent);
        Thread.sleep(5000L);
        session.close();
        con.close();
        Assert.assertEquals((long)sent, (long)listener.count);
        Thread.sleep(3000L);
        this.broker.stop();
        this.createBroker(false);
        con = this.createConnection();
        session = con.createSession(false, 1);
        producer = session.createProducer(null);
        for (i = 0; i < 10; ++i) {
            ++sent;
            message = session.createMessage();
            message.setStringProperty("filter", "false");
            producer.send((Destination)this.topic, message);
        }
        LOG.info("after restart, sent: " + sent);
        Thread.sleep(1000L);
        session.close();
        con.close();
        con = this.createConnection("offCli1");
        session = con.createSession(false, 1);
        consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", null, false);
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        Assert.assertEquals((long)sent, (long)listener.count);
    }

    public class FilterCheckListener
    extends DurableSubscriptionOfflineTestListener {
        @Override
        public void onMessage(Message message) {
            ++this.count;
            try {
                Object b = message.getObjectProperty("$b");
                if (b != null) {
                    boolean c = message.getBooleanProperty("$c");
                    Assert.assertTrue((String)"", (boolean)c);
                } else {
                    String d = message.getStringProperty("$d");
                    Assert.assertTrue((String)"", ("D1".equals(d) || "D2".equals(d) ? 1 : 0) != 0);
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
                DurableSubscriptionOffline3Test.this.exceptions.add(e);
            }
        }
    }
}

