/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class MyObject
implements Serializable {
    private static final long serialVersionUID = -2505777188753549398L;
    private String message;
    private final AtomicInteger writeObjectCalled = new AtomicInteger(0);
    private final AtomicInteger readObjectCalled = new AtomicInteger(0);
    private final AtomicInteger readObjectNoDataCalled = new AtomicInteger(0);

    public MyObject(String message) {
        this.setMessage(message);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeObjectCalled.incrementAndGet();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readObjectCalled.incrementAndGet();
    }

    public int getWriteObjectCalled() {
        return this.writeObjectCalled.get();
    }

    public int getReadObjectCalled() {
        return this.readObjectCalled.get();
    }

    public int getReadObjectNoDataCalled() {
        return this.readObjectNoDataCalled.get();
    }
}

