/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.net.URI;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.network.NetworkConnector;

public class ThreeBrokerTempQueueNetworkTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 100;
    boolean enableTempDestinationBridging = true;

    public void testTempQueueCleanup() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB", false, 2);
        this.bridgeBrokers("BrokerB", "BrokerC", false, 2);
        this.startAllBrokers();
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("BrokerC");
        Connection conn = brokerItem.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        TemporaryQueue tempQ = sess.createTemporaryQueue();
        Thread.sleep(5000L);
        for (JmsMultipleBrokersTestSupport.BrokerItem bi : this.brokers.values()) {
            ThreeBrokerTempQueueNetworkTest.assertEquals((String)("No queues on broker " + bi.broker.getBrokerName()), (int)1, (int)bi.broker.getAdminView().getTemporaryQueues().length);
        }
        tempQ.delete();
        Thread.sleep(2000L);
        for (JmsMultipleBrokersTestSupport.BrokerItem bi : this.brokers.values()) {
            ThreeBrokerTempQueueNetworkTest.assertEquals((String)("Temp queue left behind on broker " + bi.broker.getBrokerName()), (int)0, (int)bi.broker.getAdminView().getTemporaryQueues().length);
        }
    }

    public void testTempQueueRecovery() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB", false, 3);
        this.bridgeBrokers("BrokerB", "BrokerC", false, 3);
        this.startAllBrokers();
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("BrokerC");
        Connection conn = brokerItem.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        TemporaryQueue tempQ = sess.createTemporaryQueue();
        Thread.sleep(5000L);
        for (JmsMultipleBrokersTestSupport.BrokerItem bi : this.brokers.values()) {
            ThreeBrokerTempQueueNetworkTest.assertEquals((String)("No queues on broker " + bi.broker.getBrokerName()), (int)1, (int)bi.broker.getAdminView().getTemporaryQueues().length);
        }
        this.createBroker(new URI("broker:(tcp://localhost:61619)/BrokerD?persistent=false&useJmx=true"));
        this.bridgeBrokers("BrokerD", "BrokerA", false, 3);
        JmsMultipleBrokersTestSupport.BrokerItem newBroker = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("BrokerD");
        newBroker.broker.start();
        Thread.sleep(1000L);
        ThreeBrokerTempQueueNetworkTest.assertEquals((String)"No queues on broker D", (int)1, (int)newBroker.broker.getAdminView().getTemporaryQueues().length);
        tempQ.delete();
        Thread.sleep(2000L);
        for (JmsMultipleBrokersTestSupport.BrokerItem bi : this.brokers.values()) {
            ThreeBrokerTempQueueNetworkTest.assertEquals((String)("Temp queue left behind on broker " + bi.broker.getBrokerName()), (int)0, (int)bi.broker.getAdminView().getTemporaryQueues().length);
        }
    }

    public void testTempDisable() throws Exception {
        this.enableTempDestinationBridging = false;
        try {
            this.testTempQueueCleanup();
        }
        catch (Throwable e) {
            return;
        }
        ThreeBrokerTempQueueNetworkTest.fail((String)"Test should have failed since temp queues are disabled.");
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=true"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=true"));
        this.createBroker(new URI("broker:(tcp://localhost:61618)/BrokerC?persistent=false&useJmx=true"));
    }

    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName, boolean dynamicOnly, int networkTTL) throws Exception {
        NetworkConnector connector = super.bridgeBrokers(localBrokerName, remoteBrokerName, dynamicOnly, networkTTL, true);
        connector.setBridgeTempDestinations(this.enableTempDestinationBridging);
        return connector;
    }
}

