/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Topic;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.MessageIdList;

public class ThreeBrokerTopicNetworkTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 100;
    public boolean dynamicOnly;

    public void testABandBCbrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(100);
        msgsB.waitForMessagesToArrive(200);
        msgsC.waitForMessagesToArrive(200);
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsC.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((String)"Correct forwards from A", (long)100L, (long)((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"BrokerA")).broker.getDestination(ActiveMQDestination.transform((Destination)dest)).getDestinationStatistics().getForwards().getCount());
    }

    public void initCombosForTestABandBCbrokerNetworkWithSelectors() {
        this.addCombinationValues("dynamicOnly", new Object[]{true, false});
    }

    public void testABandBCbrokerNetworkWithSelectors() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB", this.dynamicOnly, 2, true);
        this.bridgeBrokers("BrokerB", "BrokerC", this.dynamicOnly, 2, true);
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerC", (Destination)dest, "dummy = 33");
        MessageConsumer clientB = this.createConsumer("BrokerC", (Destination)dest, "dummy > 30");
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest, "dummy = 34");
        Thread.sleep(2000L);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("dummy", 33);
        this.sendMessages("BrokerA", (Destination)dest, 100, props);
        props.put("dummy", 34);
        this.sendMessages("BrokerA", (Destination)dest, 200, props);
        MessageIdList msgsA = this.getConsumerMessages("BrokerC", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerC", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(100);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(200);
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsC.getMessageCount());
    }

    public void testBAandBCbrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(200);
        msgsB.waitForMessagesToArrive(100);
        msgsC.waitForMessagesToArrive(200);
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)200, (int)msgsC.getMessageCount());
    }

    public void testABandCBbrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerC", "BrokerB");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(100);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(100);
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)100, (int)msgsC.getMessageCount());
    }

    public void testAllConnectedBrokerNetwork() throws Exception {
        this.bridgeBrokers("BrokerA", "BrokerB");
        this.bridgeBrokers("BrokerB", "BrokerA");
        this.bridgeBrokers("BrokerB", "BrokerC");
        this.bridgeBrokers("BrokerC", "BrokerB");
        this.bridgeBrokers("BrokerA", "BrokerC");
        this.bridgeBrokers("BrokerC", "BrokerA");
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(300);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(300);
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsC.getMessageCount());
    }

    public void testAllConnectedBrokerNetworkSingleProducerTTL() throws Exception {
        int networkTTL = 2;
        boolean conduitSubs = true;
        this.bridgeBrokers("BrokerA", "BrokerB", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerB", "BrokerA", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerB", "BrokerC", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerC", "BrokerB", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerA", "BrokerC", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerC", "BrokerA", this.dynamicOnly, networkTTL, conduitSubs);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(new PolicyEntry());
        Collection brokerList = this.brokers.values();
        Iterator i = brokerList.iterator();
        while (i.hasNext()) {
            BrokerService broker = ((JmsMultipleBrokersTestSupport.BrokerItem)i.next()).broker;
            broker.setDestinationPolicy(policyMap);
            broker.setDeleteAllMessagesOnStartup(true);
        }
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 1);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(1);
        msgsB.waitForMessagesToArrive(1);
        msgsC.waitForMessagesToArrive(1);
        Thread.sleep(2000L);
        ThreeBrokerTopicNetworkTest.assertEquals((int)1, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)1, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)1, (int)msgsC.getMessageCount());
    }

    public void testAllConnectedBrokerNetworkDurableSubTTL() throws Exception {
        int networkTTL = 2;
        boolean conduitSubs = true;
        this.bridgeBrokers("BrokerA", "BrokerB", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerB", "BrokerA", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerB", "BrokerC", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerC", "BrokerB", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerA", "BrokerC", this.dynamicOnly, networkTTL, conduitSubs);
        this.bridgeBrokers("BrokerC", "BrokerA", this.dynamicOnly, networkTTL, conduitSubs);
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createDurableSubscriber("BrokerA", (Topic)dest, "clientA");
        MessageConsumer clientB = this.createDurableSubscriber("BrokerB", (Topic)dest, "clientB");
        MessageConsumer clientC = this.createDurableSubscriber("BrokerC", (Topic)dest, "clientC");
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 1);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(1);
        msgsB.waitForMessagesToArrive(1);
        msgsC.waitForMessagesToArrive(1);
        Thread.sleep(2000L);
        ThreeBrokerTopicNetworkTest.assertEquals((int)1, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)1, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)1, (int)msgsC.getMessageCount());
    }

    public void testAllConnectedUsingMulticast() throws Exception {
        this.bridgeAllBrokers();
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 100);
        this.sendMessages("BrokerB", (Destination)dest, 100);
        this.sendMessages("BrokerC", (Destination)dest, 100);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        MessageIdList msgsC = this.getConsumerMessages("BrokerC", clientC);
        msgsA.waitForMessagesToArrive(300);
        msgsB.waitForMessagesToArrive(300);
        msgsC.waitForMessagesToArrive(300);
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsA.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsB.getMessageCount());
        ThreeBrokerTopicNetworkTest.assertEquals((int)300, (int)msgsC.getMessageCount());
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = new String("?persistent=false&useJmx=false");
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61618)/BrokerC" + options));
    }

    @Override
    protected void configureBroker(BrokerService broker) {
        broker.setBrokerId(broker.getBrokerName());
    }

    public static Test suite() {
        return ThreeBrokerTopicNetworkTest.suite(ThreeBrokerTopicNetworkTest.class);
    }
}

