/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.util.JMXSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementContextXBeanConfigTest
extends TestCase {
    private static final String MANAGEMENT_CONTEXT_TEST_XML = "org/apache/activemq/xbean/management-context-test.xml";
    private static final String MANAGEMENT_CONTEXT_TEST_XML_CONNECTOR_PATH = "org/apache/activemq/xbean/management-context-test-connector-path.xml";
    private static final transient Logger LOG = LoggerFactory.getLogger(ManagementContextXBeanConfigTest.class);
    protected BrokerService brokerService;

    public void testManagmentContextConfiguredCorrectly() throws Exception {
        this.brokerService = this.getBrokerService(MANAGEMENT_CONTEXT_TEST_XML);
        this.brokerService.start();
        ManagementContextXBeanConfigTest.assertEquals((int)2011, (int)this.brokerService.getManagementContext().getConnectorPort());
        ManagementContextXBeanConfigTest.assertEquals((String)"test.domain", (String)this.brokerService.getManagementContext().getJmxDomainName());
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("type", "Broker");
        map.put("brokerName", JMXSupport.encodeObjectNamePart((String)"localhost"));
        ObjectName on = new ObjectName("test.domain", map);
        Object value = this.brokerService.getManagementContext().getAttribute(on, "TotalEnqueueCount");
        ManagementContextXBeanConfigTest.assertNotNull((Object)value);
    }

    public void testSuccessAuthentication() throws Exception {
        this.brokerService = this.getBrokerService(MANAGEMENT_CONTEXT_TEST_XML);
        this.brokerService.start();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:2011/jmxrmi");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{"admin", "activemq"});
        JMXConnector connector = JMXConnectorFactory.connect(url, env);
        this.assertAuthentication(connector);
    }

    public void testConnectorPath() throws Exception {
        this.brokerService = this.getBrokerService(MANAGEMENT_CONTEXT_TEST_XML_CONNECTOR_PATH);
        this.brokerService.start();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:2011/activemq-jmx");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{"admin", "activemq"});
        JMXConnector connector = JMXConnectorFactory.connect(url, env);
        this.assertAuthentication(connector);
    }

    public void testFailAuthentication() throws Exception {
        this.brokerService = this.getBrokerService(MANAGEMENT_CONTEXT_TEST_XML);
        this.brokerService.start();
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:2011/jmxrmi");
        try {
            JMXConnector connector = JMXConnectorFactory.connect(url, null);
            this.assertAuthentication(connector);
        }
        catch (SecurityException e) {
            return;
        }
        ManagementContextXBeanConfigTest.fail((String)"Should have thrown an exception");
    }

    public void assertAuthentication(JMXConnector connector) throws Exception {
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName("test.domain:type=Broker,brokerName=localhost");
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        LOG.info("Broker " + mbean.getBrokerId() + " - " + mbean.getBrokerName());
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    private BrokerService getBrokerService(String uri) throws Exception {
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

